/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities.cfg;

/**
 * an interface for classes that wish to manage their own configuration, but
 * still want to be able to save data via the CfgManager system.
 */
public interface ConfiguredObject
{
    /**
     * updates the information in this object with information currently in the
     * CfgManager.
     */
    public void updateCfg();
    
    /**
     * saves the information in this object to the proper location in the
     * CfgManager.
     */
    public void saveCfg();
}
