/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * CfgSection.java
 ************************************************************/

package utilities.cfg;

/* Global imports */
import java.beans.*;
import java.awt.*;
import java.io.*;
import java.lang.*;
import java.util.*;

import utilities.*;

public class CfgSection
{
    Hashtable items;
    
    public CfgSection()
    {
        items = new Hashtable();
    }
    
    public void addItem(CfgItem item)
    {
        if (   item.getName() == null 
            || item.getValue() == null 
            || item.getName().equals(""))
        {
            return;
        }
        if (items.containsKey(item.getName()))
            items.remove(item.getName());
        items.put(item.getName(), item);
    }
    
    public CfgItem getItem(String name)
    {
        return (CfgItem) items.get(name.toLowerCase());
    }
    
    public boolean contains(String name)
    {
        return items.containsKey(name.toLowerCase());
    }
    
    public void removeItem(String name)
    {
        if (contains(name))
            items.remove(name.toLowerCase());
    }
    
    public Iterator getItems()
    {
        //return items.elements();
        return new SortedHashtableIterator(items);
    }
   
    protected String indent(int level, String s)
    {
        if (level == 0)
            return s + "\n";
        StringBuffer b = new StringBuffer();
        while (level-- > 0)
            b.append("    ");
        b.append(s);
        b.append("\n");
        return b.toString();
    }
 
    public String toString()
    {
        StringBuffer b = new StringBuffer("{\n");
        toStringBuffer(b, 0);
        return b.toString();
    }
    
    protected void toStringBuffer(StringBuffer b, int level)
    {
        b.append(indent(level, "{"));
        Iterator i = getItems();
        while (i.hasNext())
        {
            ((CfgItem)i.next()).toStringBuffer(b, level + 1);
        }
        b.append(indent(level, "}"));
    }
}
            
