/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * CfgItem.java
 ************************************************************/

package utilities.cfg;

/* Global imports */
import java.beans.*;
import java.awt.*;
import java.io.*;
import java.lang.*;
import java.util.*;

public class CfgItem
{
    String name;
    Object value;
    CfgSection section;
    
    public CfgItem(String n, Object v)
    {
        name = n.toLowerCase();
        value = v;
    }
    
    public String getName()
    {
        return name;
    }
    
    public Object getValue()
    {
        return value;
    }
    
    public void setValue(Object o)
    {
        if (o != null)
            value = o;
    }
    
    protected static final boolean quote_vs_escape = true;
    
    protected String encode(String input)
    {
        StringBuffer b = new StringBuffer(input);
        int i = 0;
        boolean needsquoting = false;
        while (i < b.length())
        {
            switch (b.charAt(i))
            {
                case ' ':
                case '\t':
                case '\n':
                case '\r':
                    if (quote_vs_escape)
                        needsquoting = true;
                    else 
                        b.insert(i++, "\\");
                    break;
                case '\\':
                case '\"':
                    b.insert(i++, "\\");
                    break;
                default:
                    break;
            }
            i++;
        }
        if (needsquoting)
        {
            b.insert(0, "\"");
            b.insert(b.length(), "\"");
        }
        return b.toString();
    }
   
    protected String indent(int level, String s)
    {
        if (level == 0)
            return s;
        StringBuffer b = new StringBuffer();
        while (level-- > 0)
            b.append("    ");
        b.append(s);
        b.append("\n");
        return b.toString();
    }
    
    public String toString()
    {
        StringBuffer b = new StringBuffer();
        toStringBuffer(b, 0);
        return b.toString();
    }
    
    protected void toStringBuffer(StringBuffer b, int level)
    {
        if (b == null)
            return;
        if (getValue() instanceof Point)
            b.append(indent(level, encode(getName()) + " " 
                        + ((Point) getValue()).x 
                        + "," + (((Point) getValue()).y)));
        else if (getValue() instanceof CfgSection)
        {
            b.append(indent(level, encode(getName()) + " "));
            ((CfgSection)getValue()).toStringBuffer(b, level);
        } else
            b.append(indent(level, encode(getName()) + " " + 
                        encode(getValue().toString())));
    }
}

