/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;

import java.applet.*;
import java.awt.*;

public class Spline extends Object {
  public float[] Px,Py;
  public float[] Ax,Ay;
  public float[] Bx,By;
  public float[] Cx,Cy;
  public int     NP;

  private float[]    k;
  private float[][]  Mat;

  // constructor
  public Spline(float[] Px , float[] Py , int NP) {
    this.Px = new float[NP];
    this.Py = new float[NP];
    for(int i=0;i<NP ;i++) {
      this.Px[i] = Px[i];  this.Py[i] = Py[i];
    }
    Ax = new float[NP-1];
    Ay = new float[NP-1];
    Bx = new float[NP];
    By = new float[NP];
    Cx = new float[NP-1];
    Cy = new float[NP-1];
    this.NP = NP;

    k = new float[NP-1];
    Mat = new float[NP][3];
  }

  public Spline(int[] Px , int[] Py , int NP) {
    this.Px = new float[NP];
    this.Py = new float[NP];
    for(int i=0;i<NP ;i++) {
      this.Px[i] = (float)Px[i];  this.Py[i] = (float)Py[i];
    }
    Ax = new float[NP-1];
    Ay = new float[NP-1];
    Bx = new float[NP];
    By = new float[NP];
    Cx = new float[NP-1];
    Cy = new float[NP-1];
    this.NP = NP;

    k = new float[NP-1];
    Mat = new float[NP][3];
  }


  public void Generate() {
    float AMag , AMagOld;
    
    // vector A
    for(int i= 0 ; i<=NP-2 ; i++ ) {
      Ax[i] = Px[i+1] - Px[i];
      Ay[i] = Py[i+1] - Py[i];
    }
    // k
    AMagOld = (float)Math.sqrt(Ax[0]*Ax[0] + Ay[0]*Ay[0]);
    for(int i=0 ; i<=NP-3 ; i++) {
      AMag = (float)Math.sqrt(Ax[i+1]*Ax[i+1] + Ay[i+1]*Ay[i+1]);
      k[i] = AMagOld / AMag;
      AMagOld = AMag;
    }
    k[NP-2] = 1.0f;

    // Matrix
    for(int i=1; i<=NP-2;i++) {
      Mat[i][0] = 1.0f;
      Mat[i][1] = 2.0f*k[i-1]*(1.0f + k[i-1]);
      Mat[i][2] = k[i-1]*k[i-1]*k[i];
    }
    Mat[0][1] = 2.0f;
    Mat[0][2] = k[0];
    Mat[NP-1][0] = 1.0f;
    Mat[NP-1][1] = 2.0f*k[NP-2];

    // 
    for(int i=1; i<=NP-2;i++) {
      Bx[i] = 3.0f*(Ax[i-1] + k[i-1]*k[i-1]*Ax[i]);
      By[i] = 3.0f*(Ay[i-1] + k[i-1]*k[i-1]*Ay[i]);
    }
    Bx[0] = 3.0f*Ax[0];
    By[0] = 3.0f*Ay[0];
    Bx[NP-1] = 3.0f*Ax[NP-2];
    By[NP-1] = 3.0f*Ay[NP-2];

    //
    MatrixSolve(Bx);
    MatrixSolve(By);

    for(int i=0 ; i<=NP-2 ; i++ ) {
      Cx[i] = k[i]*Bx[i+1];
      Cy[i] = k[i]*By[i+1];
    }
  }


  private void MatrixSolve(float[] B) {
    float[] Work = new float[NP];
    float[] WorkB = new float[NP];

    for(int i=0;i<=NP-1;i++) {
      Work[i] = B[i] / Mat[i][1];
      WorkB[i] = Work[i];
    }

    for(int j=0 ; j<10 ; j++) {
      Work[0] = (B[0] - Mat[0][2]*WorkB[1])/Mat[0][1];
      for(int i=1; i<NP-1 ; i++ ) {
        Work[i] = (B[i]-Mat[i][0]*WorkB[i-1]-Mat[i][2]*WorkB[i+1])
          /Mat[i][1];
      }
      Work[NP-1] = (B[NP-1] - Mat[NP-1][0]*WorkB[NP-2])/Mat[NP-1][1];

      for(int i=0 ; i<=NP-1 ; i++ ) {
        WorkB[i] = Work[i];
      }
    }

    for(int i=0 ; i<=NP-1 ; i++ ) {
      B[i] = Work[i];
    }
  }

  public void draw(Graphics gra) {
    Curve c = new Curve();

    for(int i=0; i<NP-1 ; i++) {
      c.PutCurve(Ax[i],Ay[i],Bx[i],By[i],Cx[i],Cy[i]);
      c.draw(gra,Px[i],Py[i]);
    }
  }

  public Point getPoint(float dist) {
    Curve c = new Curve();

    float x = (NP - 1) * dist;
    int i = (int)x;
    float d = x - i;

    c.PutCurve(Ax[i],Ay[i],Bx[i],By[i],Cx[i],Cy[i]);
    return c.getPoint(d, Px[i], Py[i]);
  }
  
  /**
   * Shows the points used to create the spline.
   * added by kyle so I could debug stuff that used this class.
   */
  public String toString()
  {
      String s = "";
      for (int i = 0; i < NP - 1; i++)
      {
          s = s + ("[" + Px[i] + ", " + Py[i] + "]");
          if (i < NP - 2)
             s = s + (", ");
      }
      return s;
  }
  
  public void show() {
    for(int i=0; i<NP-1 ; i++) {
      System.out.println(Ax[i]+","+Ay[i]+","
                       +Bx[i]+","+By[i]+","+Cx[i]+","+Cy[i]);
      System.out.println(Px[i]+","+Py[i]);
    }
  }
}
