/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;

import java.io.*;
import java.util.*;
import java.text.*;

/**
 * this is a Iterator implementation that takes an Enumeration or
 * Iterator as input, and provides a sorted enumeration or iteration from it.
 */
public class SortedIterator implements Iterator, Enumeration
{
    Iterator i;
    
    public SortedIterator(Enumeration e)
    {
	List l = new ArrayList();
	while (e.hasMoreElements()) { l.add(e.nextElement()); }
	Collections.sort(l);
	this.i = l.iterator();
    }

    public SortedIterator(Iterator i)
    {
	List l = new ArrayList();
	while (i.hasNext()) { l.add(i.next()); }
	Collections.sort(l);
	this.i = l.iterator();
    }

    public Object next() throws NoSuchElementException
    {
        return i.next();
    }
    
    public Object nextElement() throws NoSuchElementException
    {
        return i.next();
    }
    
    public boolean hasNext()
    {
        return i.hasNext();
    }
    
    public boolean hasMoreElements()
    {
        return i.hasNext();
    }
    
    public void remove() throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException();
    }
}
