/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;

import java.io.*;
import java.util.*;
import java.text.*;

/**
 * this is a Iterator implementation that takes a hashtable as input, and
 * returns values in sorted order.
 */
public class SortedHashtableIterator implements Iterator, Enumeration
{
    TreeMap map;
    Iterator i;
    
    public SortedHashtableIterator(Hashtable h)
    {
        map = new TreeMap(Collator.getInstance());
        map.putAll(h);
        i = map.values().iterator();
    }

    public Object next() throws NoSuchElementException
    {
        return i.next();
    }
    
    public Object nextElement() throws NoSuchElementException
    {
        return i.next();
    }
    
    public boolean hasNext()
    {
        return i.hasNext();
    }
    
    public boolean hasMoreElements()
    {
        return i.hasNext();
    }
    
    public void remove() throws UnsupportedOperationException
    {
        throw new UnsupportedOperationException();
    }
}
