/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * SortEnumeration.java
 ************************************************************/

package utilities;

/* Global imports */
import java.util.*;


/**
 * Grabs all the elements in an enumeration and stores them
 * locally before enumerating over them.  This allows you to
 * safely modify the original structure you are enumerating
 * while you are enumerating.
 */
public class SortEnumeration implements Enumeration {
  Enumeration enumeration;

  public SortEnumeration(Enumeration e) {
    this(e, false);
  }

  public SortEnumeration(Enumeration e, boolean r) {
    Vector v = new Vector();
    
    while (e.hasMoreElements()) {
	v.addElement(e.nextElement()); 
    }
    sort(v, r);
    enumeration = v.elements();
  }

  public boolean hasMoreElements() {
    return (enumeration.hasMoreElements());
  }
  
  public Object nextElement() {
    return (enumeration.nextElement());
  }

  public void sort(Vector v, boolean r) {
    Object low;
    int lowindex;
    
    for (int i = 0; i < v.size() - 1; i++) {
       low = v.elementAt(i);
       lowindex = i;
       for (int j = i + 1; j < v.size(); j++) {
          Object compare = v.elementAt(j);
          if (r) {
	     if (!lower(compare, low)) {
                low = compare;
                lowindex = j;
             }
          } else {
	     if (lower(compare, low)) {
                low = compare;
                lowindex = j;
             }
          }
       }
       if (i != lowindex) {
          Object temp = v.elementAt(i);
          v.setElementAt(low, i);
          v.setElementAt(temp, lowindex);
       }
    }
  }

  public boolean lower(Object c, Object o) {
    String sc, so;

    if (c instanceof String)
       sc = (String)c;
    else
       sc = c.toString();

    if (o instanceof String)
       so = (String)o;
    else
       so = o.toString();

    sc = sc.toLowerCase();
    so = so.toLowerCase();

    return (sc.compareTo(so) < 0);
  }
}
