/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;

import java.util.*;

public class SimpleEmbedding implements Embedding
{
    Set nodes, edges;
    Map edge_orderings, minimum_angles;
    
    public SimpleEmbedding(Set nodes, Set edges)
    {
        setGraph(nodes, edges);
    }
    
    public void setGraph(Set n, Set e)
    {
        nodes = n;
        Iterator i = e.iterator();
        edges = new HashSet();
        while (i.hasNext())
        {
            List l = (List) i.next();
            edges.add(new EdgeList(l));
        }
        produceOrdering();
    }
    
    public Iterator getNodes()
    {
        return edge_orderings.keySet().iterator();
    }
    
    public Iterator getEdges()
    {
        return edges.iterator();
    }
    
    public Iterator getEdgeOrderings()
    {
        return edge_orderings.values().iterator();
    }
    
    public Iterator getMinimumAngles()
    {
        return minimum_angles.values().iterator();
    }

    public Iterator getEdgeOrder(Object node)
    {
        return ((List) edge_orderings.get(node)).iterator();
    }
    
    public int getMinimumAngle(Object node)
    {
        return ((Integer) minimum_angles.get(node)).intValue();
    }
    
    protected synchronized void produceOrdering()
    {
        Iterator i = getNodes();
        edge_orderings = new TreeMap();
        minimum_angles = new TreeMap();
        while (i.hasNext())
        {
            Object o = i.next();
            edge_orderings.put(o, new Vector());
            minimum_angles.put(o, new Integer(10));
        }
        i = getEdges();
        while (i.hasNext())
        {
            List edge = new EdgeList((List) i.next());
            List node1 = (List) edge_orderings.get(edge.get(0));
            List node2 = (List) edge_orderings.get(edge.get(1));
            if (!node1.contains(edge))
                node1.add(edge);
            if (!node2.contains(edge))
                node2.add(edge);
        }
    }
    
    protected boolean edgeEquals(List edge1, List edge2)
    {
        if (edge1.get(0) == edge2.get(0))
            if (edge1.get(1) == edge2.get(1))
                return true;
        if (edge1.get(0) == edge2.get(1))
            if (edge1.get(2) == edge2.get(0))
                return true;
        return false;
    }
            
    protected class EdgeList extends Vector
    {
        public EdgeList(List l)
        {
            this(l.get(0), l.get(1));
        }
        
        public EdgeList(Object e1, Object e2)
        {
            add(e1);
            add(e2);
        }
        
        public boolean equals(Object o)
        {
            if (o instanceof EdgeList)
            {
                EdgeList edge = (EdgeList) o;
                if (edge.get(0) == get(0))
                    if (edge.get(1) == get(1))
                        return true;
                if (edge.get(0) == get(1))
                    if (edge.get(2) == get(0))
                        return true;
            }
            return false;
        }
    }   
}
