/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * EnumerationEnumeration.java
 ************************************************************/

package utilities;

/* Global imports */
import java.util.*;


/**
 * Reverses an enumeration
 */
public class ReverseEnumeration implements Enumeration {
  Enumeration enumr;

  public ReverseEnumeration(Enumeration e) {
    enumr = prime(e);
  }

  private Enumeration prime(Enumeration e) {
    Vector elements = new Vector();

    while((e != null) && (e.hasMoreElements())) {

      elements.insertElementAt(e.nextElement(), 0);
    }

    return elements.elements();
  }
  
  public boolean hasMoreElements() {

    return (enumr.hasMoreElements());
  }
  
  public Object nextElement() {

    return enumr.nextElement();
  }
}
