/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * NumberSortEnumeration.java
 ************************************************************/

package utilities;

/* Global imports */
import java.util.*;


/**
 */
public class NumberSortEnumeration extends SortEnumeration {
  Enumeration enumeration;

  public NumberSortEnumeration(Enumeration e) {
    super(e);
  }

  public NumberSortEnumeration(Enumeration e, boolean r) {
    super(e, r);
  }

  public boolean lower(Object c, Object o) {
    float fc, fo;

    if (c instanceof Number)
	fc = ((Number)c).floatValue();
    else {
      String s;
      if (c instanceof String)
         s = (String)c;
      else
         s = c.toString();
      fc = Float.valueOf(s).floatValue();
    }

    if (o instanceof Number)
	fo = ((Number)o).floatValue();
    else {
      String s;
      if (o instanceof String)
         s = (String)o;
      else
         s = o.toString();
      fo = Float.valueOf(s).floatValue();
    }

    return (fc < fo);
  }
}
