/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;
import java.lang.reflect.*;
import utilities.Log;

    /**
     * Loads a class, given its name
     */
public class LoadClass {
   /**
     * Loads a class, given its name
     * @param n The class name
     * @param args The constructor arguments
     * @return The class instance, or null if an error occured
     */
    public static Object load(String n, Object []args) {
		Object o = null;
		Log log = Log.getDefault();
	
		//		log.log("Creating " + n, 3);

		// Find the class
		Class c = null;
		n = n.trim();
		try {
			c = Class.forName(n);
		} catch (ClassNotFoundException e) {
			log.log("Error: Cannot find class " + n + "\n" + e, 0);
		}

		// Make an instance
		if (c != null) {
			Class cargs[] = new Class[args.length];
			try {
				for (int i = 0; i < args.length; i++)
					cargs[i] = args[i].getClass();
				Constructor cons = c.getConstructor(cargs);
				o = cons.newInstance(args);
			} catch (Exception e) {
				log.log("Error creating object " + c + ": " + e, 0);
				log.log("(constructor type we looked for: ", 0);
				for (int i = 0; i < cargs.length; i++)
					log.log(cargs[i].getName(), 0);
				log.log(")", 0);
			}
		}

		return o;
    }

    public static Object load(String n, Object []args, Class []cargs) {
		Object o = null;
		Log log = Log.getDefault();
	
		//		log.log("Creating " + n, 3);

		// Find the class
		Class c = null;
		n = n.trim();
		try {
			c = Class.forName(n);
		} catch (ClassNotFoundException e) {
			log.log("Error: Cannot find class " + n + "\n" + e, 0);
		}

		// Make an instance
		if (c != null) {
			try {
				Constructor cons = c.getConstructor(cargs);
				o = cons.newInstance(args);
			} catch (Exception e) {
				log.log("Error creating object " + c + ": " + e, 0);
				log.log("(constructor type we looked for: ", 0);
				for (int i = 0; i < cargs.length; i++)
					log.log(cargs[i].getName(), 0);
				log.log(")", 0);
			}
		}

		return o;
    }
}
