/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	ImageComponent.java
 ***************************************************************************************/
package utilities;

/* Global Includes */
import java.awt.*;
import java.awt.image.*;
import java.net.*;
import javax.swing.*;

/**
 * An image placeholder
 */
public class JImageComponent extends JComponent {
  private Image image;
  private Dimension size;
  private MediaTracker tracker = new MediaTracker(this);

  /**
   * Constructor
   * @param i The image to display
   */
  public JImageComponent(Image i) {
    setImage(i);
  }

  /**
   * Constructor
   * @param u The URL of the image
   */
  public JImageComponent(URL u) {
    setImage(u);
  }

  /**
   * Sets the image icon
   * @param u The URL of the image
   */
  public void setImage(URL u) {
    setImage(Toolkit.getDefaultToolkit().getImage(u));
  }


  /**
   * Sets the image icon
   * @param i The image
   */
  public void setImage(Image i) {

    image = i;

    // Load it, so we get the correct bounds
    MediaTracker m = new MediaTracker(this);
    tracker.addImage(image, 1);
    init();

    repaint();
  }

  /**
   * Sets up the preferred size
   */
  public void init() {

    try {
      tracker.waitForAll();
    } catch (InterruptedException e) { }
    size = new Dimension(image.getWidth(this), image.getHeight(this));
  }

  /**
   * I forget what this does
   */
  public void addNotify () {
    super.addNotify();
    init();
  }

  /**
   * Paints the image
   */
  public void paint(Graphics g) {
    g.drawImage(image, getX(), getY(), this);
    //System.err.println("drawing image " + image);
    //list();
  }

  /**
   * Retrurns the size of the image
   */
  public Dimension getPreferredSize() {
    init();
    return size;
  }
  public Dimension getMinimumSize() {
    return getPreferredSize();
  }
  public Dimension getMaximumSize() {
    return getPreferredSize();
  }
}
