/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	GraphTest.java
 ***************************************************************************************/

package utilities;

/* Global Inclues */
import javax.swing.*;

import java.applet.*;
import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

import utilities.cfg.*;

/**
 */
public class GraphTest extends Panel implements  Runnable {
	
  /**
   */
  public GraphTest() {
  }

  /**
   */
  public synchronized void run() {

    System.err.println("Test has started.\n");

    Graph graph = new Graph("GraphTest");
    final CfgManager manager = new CfgManager("graphtest.cfg");
    manager.addConfiguredObject(graph, "/graph");
    graph.addLayer("I am a layer");
    GraphNode test1 = new GraphNode("test 1");
    GraphNode test6 = new GraphNode("test 2");
    GraphNode test3 = new GraphNode("test 3");
    GraphEdge test4 = new GraphEdge("test 4", test1, test6);
    GraphEdge test5 = new GraphEdge("test 5", test6, test3);
    GraphNode bedroom = new GraphNode("Bedroom");
    bedroom.addEdge(test1);
    NodePanel bedroom_panel2 = new NodePanel();
    bedroom_panel2.setLabel("bedroom panel 2");
    test3.addEdge(test1);
    graph.addNode(test1);
    GraphEdge crosslayer = new GraphEdge(test1, bedroom);
            
    graph.setDefaultLayer("I am a layer");
    
    GraphNode bathroom = new GraphNode("Bathroom");
    GraphNode hallway = new GraphNode("Hallway");
    GraphNode livingroom = new GraphNode("Living Room");
    GraphNode kitchen = new GraphNode("Kitchen");
    
    ContainerGraphNode mind = new ContainerGraphNode("mind");
    
    ContainerGraphNode test = new ContainerGraphNode("test");
    
    GraphNode quit = new GraphNode("quit");
    graph.addNode(quit, new JPanel(), "default");
    JButton button = new JButton("quit");
    button.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    manager.save();
                    System.exit(0);
                }
            });
    graph.getLayers().getTopPanel(quit).add(button);
    //((NodePanel)graph.getLayers().getTopPanel(quit)).setShape(
    //                    new Rectangle(50, 50, 100, 100));
    graph.getLayers().getTopPanel(quit).revalidate();
    
    
    
    bedroom.addEdge(bathroom);
    bedroom.addEdge(hallway);
    livingroom.addEdge(hallway);
    livingroom.addEdge(kitchen);
    kitchen.addEdge(hallway);
    
    GraphEdge edgetest = new GraphEdge("test", mind, test);
    
    //edgetest.setLocation(new Point(100, 100));
    //edgetest.setMoveable(false);
    
    GraphNode watertank = new GraphNode("Water tank");
    GraphEdge pipe1 = new GraphEdge("pipe to bathroom", watertank, bathroom);
    GraphEdge pipe2 = new GraphEdge("pipe to kitchen", watertank, kitchen);
    watertank.addEdge(mind);
    //pipe1.setEndPoints(watertank, (GraphNode) bathroom);
    //pipe2.setEndPoints(watertank, (GraphNode) kitchen);
    
    GraphNode heater = new GraphNode("Water heater");
    GraphEdge pipe3 = new GraphEdge("pipe to water heater", watertank, heater);
    GraphEdge pipe4 = new GraphEdge("hot pipe to kitchen", heater, kitchen);
    GraphEdge pipe5 = new GraphEdge("hot pipe to bathroom", heater, bathroom);
    //pipe3.setEndPoints(watertank, (GraphNode) heater);
    //pipe4.setEndPoints(heater, (GraphNode) kitchen);
    //pipe5.setEndPoints(heater, (GraphNode) bathroom);
    
    /*
    GraphEdge e1 = new GraphEdge("Bedroom to Bathroom");
    GraphEdge e2 = new GraphEdge("Bedroom to Hallway");
    GraphEdge e3 = new GraphEdge("Living Room to Hallway");
    GraphEdge e4 = new GraphEdge("Living Room to Kitchen");
    GraphEdge e5 = new GraphEdge("Kitchen to Hallway");
    
    e1.setEndPoints(bedroom, bathroom);
    e2.setEndPoints(bedroom, hallway);
    e3.setEndPoints(livingroom, kitchen);
    e4.setEndPoints(livingroom, hallway);
    e5.setEndPoints(kitchen, hallway);
    */
    
    graph.addTree(bedroom);
    graph.addToLayer("default", bedroom, bedroom_panel2);
    
    GraphNode thoughts = new GraphNode("thoughts");
    GraphNode being = new GraphNode("being");
    ContainerNodePanel cpanel = (ContainerNodePanel) 
        graph.getLayers().getPanel("I am a layer", mind);
    mind.addContained(cpanel, thoughts);
    mind.addContained(cpanel, being);
    cpanel.setShape(new Rectangle(20, 20, 200, 200));
    
    cpanel = (ContainerNodePanel) graph.getLayers().getPanel("I am a layer", 
            test);
    cpanel.setShape(new Rectangle(100, 100, 150, 200));
    GraphNode test2 = new GraphNode("lots of little tests");
    test.addContained(cpanel, test2);
    test.addEdge(mind);
    
    try {
        cpanel.setBackImage(new ImageComponent(new URL("http://dis.cs.umass.edu/~rawlins/usa_map.jpg")));
    } catch (MalformedURLException e) {
        System.err.println("Unable to load image.");
        //cpanel.setBackImage(null);
    }
    
    cpanel.setLinkLocation("test", new Point(50, 50));
    //graph.addNode(bathroom);
    //graph.addNode(livingroom);
    //graph.addNode(kitchen);
    //graph.addNode(hallway);
    //graph.addNode(watertank);
    //graph.addNode(heater);
    
    System.err.println("******DISCLAIMER*******");
    System.err.println("This demo does NOTHING.  \nIt just looks like it does something.  \nDon't be fooled!");
    
    /*JPopupMenu menu = new JPopupMenu();
    JMenuItem m = new JMenuItem("Quit");
    m.addActionListener(new ActionListener()
        {
            quit();
        });
    menu.add(m);
    graph.putClientProperty("GraphMenu", menu);
    menu.setInvoker(c);
    */
    showGraph(graph);

  }

  private static final int INITIAL_WIDTH = 1000;
  private static final int INITIAL_HEIGHT = 400;
  public void showGraph(Graph g) {
    JFrame frame;

    frame = new JFrame("GraphTest"); 

    frame.setSize(INITIAL_WIDTH, INITIAL_HEIGHT);
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    frame.setLocation(screenSize.width/2 - INITIAL_WIDTH/2,
		      screenSize.height/2 - INITIAL_HEIGHT/2);
    frame.getContentPane().add(g, BorderLayout.CENTER);
    frame.show();
  }

  /**
   * Main function. This function read the configuration file, all generator 
   * grammars and the resources scripting file.
   */
  public static void main(String args[]) {
    
    GraphTest test = new GraphTest();
    test.run();
  }
}
