/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * GraphNodeFinderEnumeration.java
 ************************************************************/

package utilities;

/* Global imports */
import java.awt.*;
import java.io.*;
import java.util.*;

/**
 * Node finder
 */
class GraphNodeFinderEnumeration implements Enumeration {
    Vector matches = new Vector();
    GraphNode match;
    static int sequence = 0;
    static GraphNodeFinderEnumeration cache = null;
    
    static void invalidateCache()
    {
        sequence++;
    }
    
    public static int cacheGraph(Enumeration es, GraphNode m)
    {        
        cache = new GraphNodeFinderEnumeration(es, m);
        invalidateCache();
        return sequence;
    }
    
    public static int cacheGraph(GraphNode s, GraphNode m)
    {
        cache = new GraphNodeFinderEnumeration(s, m);
        invalidateCache();
        return sequence;
    }
    
    public static boolean checkCache(int seq)
    {
        return (seq == sequence);
    } 
    
    private void dup(GraphNodeFinderEnumeration src)
    {
        this.matches = (Vector) src.matches.clone();
        this.nonmatches = (Vector) src.nonmatches.clone();
        this.match = src.match;
    }
    
    public GraphNodeFinderEnumeration(Enumeration es, GraphNode m, int seq)
    {
        if (seq == sequence)
            dup(cache);
        else
            creation(es, m);
    }
    
    public GraphNodeFinderEnumeration(GraphNode s, GraphNode m, int seq)
    {
        if (seq == sequence)
            dup(cache);
        else
            creation(s, m);
    }
    
    public GraphNodeFinderEnumeration(Enumeration es, GraphNode m)
    {
        creation(es, m);
    }
    
    protected void creation(Enumeration es, GraphNode m) 
    {
        match = m;

        while (es.hasMoreElements()) {
            GraphNode s = (GraphNode)es.nextElement();
            findMatches(s);
        }
    }
    
    public GraphNodeFinderEnumeration(GraphNode s, GraphNode m)
    {
        creation(s, m);
    }

    protected void creation(GraphNode s, GraphNode m) 
    {
        match = m;
        findMatches(s);
    }

    public boolean hasMoreElements() {
        return (!matches.isEmpty());
    }

    public Object nextElement() {
        Object o = matches.firstElement();
        matches.removeElement(o);
        return o;
    }
    
    Vector nonmatches = new Vector();
    private void findMatches(GraphNode n) {
        Enumeration e;

        if (matches.contains(n)) return;
        if (nonmatches.contains(n)) return;
        if (match == null || n.equals(match)) {
            matches.addElement(n);
        } else
            nonmatches.addElement(n);

        e = n.getOutEdges();
        while (e.hasMoreElements()) {
            findMatches((GraphNode)e.nextElement());
        }
        e = n.getInEdges();
        while (e.hasMoreElements())
        {
            findMatches((GraphNode) e.nextElement());
        }
        e = n.getUndirEdges();
        while (e.hasMoreElements())
        {
            findMatches((GraphNode) e.nextElement());
        }
    }
}
