/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * GraphLayers.java
 ************************************************************/

package utilities;

/* Global imports */
import javax.swing.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import utilities.cfg.*;

public class GraphLayers implements ConfiguredObject
{
    Hashtable layers;
    Vector visible_layers;
    
    static GraphLayers global_hack = null;
    
    public static GraphLayers getGlobal()
    {
        return global_hack;
    }
    
    public GraphLayers(JTabbedPane p)
    {
        panel = p;
        layers = new Hashtable();
        visible_layers = new Vector();
        addLayer("default");
        //setVisible("default", true);
        global_hack = this;
    }
    
    public void addLayer(String name)
    {
        GraphLayer g = new GraphLayer(name);
        panel.addTab(name, g.getPanel());
        layers.put(name, g);
    }
    
    public void removeLayer(String name)
    {
        layers.remove(name);
        if (visible_layers.contains(name))
            visible_layers.removeElement(name);
    }
    
    public void addToLayer(String name, GraphNode mem, JPanel panel)
    {
        if (!layers.containsKey(name))
        {
            addLayer(name);
        }
        GraphLayer g = (GraphLayer) layers.get(name);
        if (!g.contains(mem))
        {
            g.addToLayer(mem, panel);
            //panel.setVisible(isVisible(name));
        }
    }
    
    public void removeFromLayer(String name, GraphNode mem)
    {
        if (layers.containsKey(name))
        {
            GraphLayer g = (GraphLayer) layers.get(name);
            if (g.contains(mem))
                g.removeFromLayer(mem);
        }
    }
    
    public Enumeration getLayers()
    {
        return layers.keys();
    }
    
    public Enumeration getLayers(GraphNode mem)
    {
        Enumeration e = layers.keys();
        Enumeration f = layers.elements();
        Vector v = new Vector();
        
        while (e.hasMoreElements())
        {
            if (((GraphLayer) f.nextElement()).contains(mem))
                v.addElement(e.nextElement());
            else
                e.nextElement();
        }
        return v.elements();
    }
    
    public void eliminate(GraphNode mem)
    {
        Enumeration e = getLayers(mem);
        while (e.hasMoreElements())
        {
            removeFromLayer((String) e.nextElement(), mem);
        }
    }
    
    public String getVisible()
    {
        Enumeration e = getLayers();
        while (e.hasMoreElements())
        {
            String s = (String) e.nextElement();
            if (getLayer(s).getPanel() == panel.getSelectedComponent())
            {
                return s;
            }
        }
        return null;
    }
    
    public boolean isVisible(String name)
    {
        //if (name == null)
        //    return false;
        //return visible_layers.contains(name);
        return true;
    }
    
    public void setVisible(String name, boolean b)
    {
        /*if (name == null)
            return;
        //if (visible_layers.contains(name))
        //    visible_layers.remove(name);
        if (b)
        {
            visible_layers = new Vector();
            visible_layers.addElement(name);
        }*/
        //getLayer(name).setVisible(b);
        GraphLayer l = getLayer(name);
    }
    
    public boolean isObjectVisible(GraphNode mem)
    {
        String s = getVisible();
        return (isInLayer(s, mem) && isVisible(s));
    }
   
    public JPanel getPanel(String layer, GraphNode n)
    {
        if (layer != null && isInLayer(layer, n))
            return getLayer(layer).getPanel(n);
        else
            return null;
    }
    
    public JPanel getTopPanel(GraphNode n)
    {
        String s = getVisible();
        if (s != null && isInLayer(s, n))
            return getLayer(s).getPanel(n);
        else
            return null;
    }
    
    public boolean isInLayer(String layer, GraphNode mem)
    {
        return ((GraphLayer)layers.get(layer)).contains(mem);
    }
    
    public GraphLayer getLayer(String name)
    {
        if (!layers.containsKey(name))
            return null;
        return (GraphLayer) layers.get(name);
    }
    
    JTabbedPane panel = null;
    
    protected void addCBForLayer(String s)
    {
        JCheckBox cb = new JCheckBox(s, isVisible(s));
        cb.addActionListener(new ActionListener()
            {
                public void actionPerformed(ActionEvent e)
                {
                    JCheckBox ch = (JCheckBox) e.getSource();
                    setVisible(ch.getText(), !isVisible(ch.getText()));
                }
            });
        panel.add(cb);
    }
    
    protected void setDisplay(JTabbedPane p)
    {
        panel = p;
    }
    
    public synchronized void updateCfg()
    {
        
    }
    
    public synchronized void saveCfg()
    {
        
    }
} 
    
   
   
