/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * GraphLayer.java
 ************************************************************/

package utilities;

/* Global imports */
import javax.swing.*;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import utilities.cfg.*;

public class GraphLayer implements ConfiguredObject
{
    protected Hashtable members;
    protected Hashtable components;
    protected Hashtable locations;
    protected String name;
    boolean visible = false;
    boolean willsave = true;
    String savefile;
    JPanel panel;
    
    public GraphLayer(String n, JPanel p)
    {
        name = n;
        locations = new Hashtable();
        members = new Hashtable();
        components = new Hashtable();
        savefile = new String("resourcenodes-" + name + ".cfg");
        if (p == null)
            panel = Graph.globalhack.createCanvas(savefile);
        else
            panel = p;
    }
    
    public GraphLayer(String n)
    {
        this(n, null);
    }
    
    public GraphLayer()
    {
        this("default");
    }
    
    public String getName()
    {
        return name;
    }
    
    public void setName(String n)
    {
        name = n;
    }
    
    public JPanel getPanel()
    {
        return panel;
    }
    
    public boolean isVisible()
    {
        //return visible;
        return true;
    }
    
    /*public void setVisible(boolean b)
    {
        visible = b;
        Enumeration e = panels();
        while (e.hasMoreElements())
        {
            ((JPanel) e.nextElement()).setVisible(b);
        }
    }*/
    
    public boolean willSave()
    {
        return willsave;
    }
    
    public void setWillSave(boolean b)
    {
        willsave = b;
    }
    
    public GraphNode getNode(Component c)
    {
        if (components.containsKey(c))
            return (GraphNode) components.get(c);
        else
            return null;
    }
    
    protected String getSaveName(Component c)
    {
        String s = null;
        GraphNode n;
        if ((n = getNode(c)) != null)
        {
            if (n instanceof GraphNode)
            {
                s = n.getLabel();
                if ((s == null || s == "") && n instanceof GraphEdge)
                    s = "Edge: " + ((GraphEdge) n).getFrom().getLabel() +" to " + ((GraphEdge)n).getTo().getLabel();
            }
        } else
            s = String.valueOf(c.hashCode());
        return s;
    }

    public void storeNodePlacement(Component c)
    {
        String s = getSaveName(c);
        
        if (s != null && s != "")
            locations.put(s, c.getLocation());
    }
     
    public Point restoreNodePlacement(Component c)
    {
        String s = getSaveName(c);
        Point loading = null;
        if (s != null && locations.containsKey(s))
            loading = (Point) locations.get(s);

        if (loading != null)
            loading = new Point(loading.x, loading.y);
        return loading;
    }
    
    public boolean hasStoredPlace(Component c)
    {
        return (getSaveName(c) != null && locations.containsKey(getSaveName(c)));
    }
    
    public void addToLayer(GraphNode n, Component c)
    {
        if (n != null && !members.containsKey(n))
        {
            if (c == null)
                c = n.getDefaultPanel();
            members.put(n, c);
            components.put(c, n);
            panel.add(c, n);
            CfgManager manager = CfgManager.getManager(n);
            if (manager != null && c instanceof ConfiguredObject)
            {
                manager.addConfiguredObject((ConfiguredObject) c, 
                        manager.getObjectKey(n) + "/layers/" + getName());
            }
            //c.setVisible(isVisible());
        }
    }
   
    public synchronized void removeFromLayer(GraphNode n)
    {
        if (n != null && members.containsKey(n))
        {
            panel.remove((JPanel)members.get(n));
            components.remove(members.get(n));
            members.remove(n);
        }
    }
    
    public boolean contains(Object n)
    {
        return members.containsKey(n);
    }
   
    public boolean isPlaced(GraphNode n)
    {
        if (contains(n))
        {
            return locations.containsKey(getSaveName((Component)members.get(n)));
        } else
            return false;
    }
    
    public Enumeration elements()
    {
        return members.keys();
    }
    
    public Enumeration panels()
    {
        return members.elements();
    }
    
    public JPanel getPanel(GraphNode n)
    {
        return (JPanel)members.get(n);
    }
    
    public int hashCode()
    {
        return name.hashCode();
    }
    
    public synchronized void updateCfg()
    {
        
    }
    
    public synchronized void saveCfg()
    {
        
    }
}
