/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * EnumerationEnumeration.java
 ************************************************************/

package utilities;

/* Global imports */
import java.awt.*;
import java.io.*;
import java.util.*;


/**
 * Enumerates a vector of enumerations
 */
public class EnumerationEnumeration implements Enumeration {
  Vector enums = new Vector();
  Enumeration e;

  public EnumerationEnumeration(Vector ens) {
    enums = ens;
    prime();
  }

  public EnumerationEnumeration(Vector ens, boolean uniq) {

    if (uniq) {
      Vector v = new Vector();
      Enumeration t1 = ens.elements();
      while (t1.hasMoreElements()) {
	Enumeration t2 = (Enumeration)t1.nextElement();
	while (t2.hasMoreElements()) {
	  Object o = t2.nextElement();
	  if (! v.contains(o))
	    v.addElement(o);
	}
      }
      enums = new Vector();
      enums.addElement(v.elements());
    } else {
      enums = ens;
    }

    prime();
  }

  private void prime() {

    while((e == null) || (!e.hasMoreElements())) {

      if (enums.isEmpty()) {
	e = null;
	return;
      }

      e = (Enumeration)enums.firstElement();
      enums.removeElement(e);
    }
  }
  
  public boolean hasMoreElements() {

    prime();
    return (e != null);
  }
  
  public Object nextElement() {

    prime();
    if (e != null)
      return e.nextElement();
    else
      return null;
  }
}
