/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

package utilities;

import java.applet.*;
import java.awt.*;

public class Curve extends Object {
  public float  Ax,Ay;
  public float  Bx,By;
  public float  Cx,Cy;
  public int    Ndiv;
  
  
  public Curve(float Ax,float Ay,float Bx,float By,float Cx,float Cy,int Ndiv) {
    this.Ax = Ax; this.Ay = Ay;
    this.Bx = Bx; this.By = By;
    this.Cx = Cx; this.Cy = Cy;
    this.Ndiv = Ndiv;
  }
  public Curve(float Ax,float Ay,float Bx,float By,float Cx,float Cy) {
    this.Ax = Ax; this.Ay = Ay;
    this.Bx = Bx; this.By = By;
    this.Cx = Cx; this.Cy = Cy;
    this.Ndiv = (int)(Math.max(Math.abs(Ax),Math.abs(Ay))/2.0f);
  }
  public Curve() {};

  public void PutCurve(float Ax,float Ay,float Bx,float By,float Cx,float Cy) {
    this.Ax = Ax; this.Ay = Ay;
    this.Bx = Bx; this.By = By;
    this.Cx = Cx; this.Cy = Cy;
    this.Ndiv = (int)(Math.max(Math.abs(Ax),Math.abs(Ay))/2.0f);
  }

  public void draw(Graphics gra,float x,float y) {
    int OrigX ,OrigY , NewX,NewY;
    float  t , f,g,h;
    int Ndiv = this.Ndiv;

    if (Ndiv==0) Ndiv=1;

    OrigX = (int)x; OrigY= (int)y;
    for(int i=1 ; i<=Ndiv ; i++ ) {
      t = 1.0f / (float)Ndiv * (float)i;
      f = t*t*(3.0f-2.0f*t);
      g = t*(t-1.0f)*(t-1.0f);
      h = t*t*(t-1.0f);
      NewX = (int)(x + Ax*f + Bx*g + Cx*h);
      NewY = (int)(y + Ay*f + By*g + Cy*h);
      gra.drawLine(OrigX , OrigY , NewX,NewY);
      OrigX = NewX;  OrigY=NewY;
    }
  }

  public Point getPoint(float dist, float x,float y) {
    int OrigX ,OrigY , NewX,NewY;
    float  t , f,g,h;
    int Ndiv = this.Ndiv;

    if (Ndiv==0) Ndiv=1;

    int distseg = Math.round((float)(Ndiv - 1) * dist) + 1;

    OrigX = (int)x; OrigY= (int)y;
    for(int i=1 ; i<=Ndiv ; i++ ) {
      t = 1.0f / (float)Ndiv * (float)i;
      f = t*t*(3.0f-2.0f*t);
      g = t*(t-1.0f)*(t-1.0f);
      h = t*t*(t-1.0f);
      NewX = (int)(x + Ax*f + Bx*g + Cx*h);
      NewY = (int)(y + Ay*f + By*g + Cy*h);
      if (i == distseg) {
        return new Point(OrigX, OrigY);
      }
      OrigX = NewX;  OrigY=NewY;
    }

    return new Point(0,0);
  }
}
