/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * ContainerNodePanel.java
 ************************************************************/

package utilities;

import java.awt.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import javax.swing.*;


public class ContainerNodePanel extends NodePanel
{
    protected Dimension labelsize = null;
    HashMap linklocations;
    
    public ContainerNodePanel(ContainerGraphNode n, String l)
    {
        super(n, l);
        linklocations = new HashMap();
        setLayout(new GraphLayout());
        setOpaque(false);
    }
    
    protected ContainerNodePanel()
    {
        this(null, new String(""));
    }
    
    public Dimension getLabelSize()
    {
        return labelsize;
    }

    public void repaint()
    {
        if (getParent() != null)
            getParent().repaint();
        else
            super.repaint();
    }
    
    public boolean isOptimizedDrawingEnabled()
    {
        return false;
    }

    public void paintComponent(Graphics g)
    {
        Rectangle rect = new Rectangle(this.getBounds());
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.black);
        g.drawRect(0, 0, rect.width - 1, rect.height - 1);
        try {
            labelsize = new Dimension(fm.stringWidth(getLabel()) + 
                    H_MARGIN * 2, fm.getHeight());
            if (isSelected())
                g.setColor(Color.yellow);
            else
                g.setColor(Color.white);
            g.fillRoundRect(H_MARGIN, rect.height - labelsize.height,
                    labelsize.width, labelsize.height - V_MARGIN, 5, 5);
            g.setColor(getForeground());
            g.drawRoundRect(H_MARGIN, rect.height - labelsize.height,
                    labelsize.width, labelsize.height - V_MARGIN, 
                    5, 5);
            g.drawString(getLabel(), H_MARGIN * 2, rect.height -
                    V_MARGIN * 2);
        } catch (java.lang.NullPointerException ex) {
            System.err.println("Error drawing label");
            ex.printStackTrace();
        }
    }
    
    public Point getLinkLocation(String name)
    {
        return (Point) linklocations.get(name);
    }
    
    public void setLinkLocation(String name, Point loc)
    {
        linklocations.put(name, loc);
    }

    public Point getLocationForLine()
    {
        Dimension d;
        d = getLabelSize();
        if (d == null)
            d = getSize();
        int x = getX() + d.width / 2;
        int y = getY() + getHeight() - d.height / 2;
        return new Point(x, y);
    }

    public Point getLocationForLine(GraphNode n)
    {
        Point tmp = (Point) linklocations.get(n);
        if (tmp != null)
            return tmp;
        else
            return getLocationForLine();
    }

    public boolean intersects(Rectangle r)
    {
        Rectangle r2;
        if ((r2 = getBounds()) !=  null)
            return r.intersects(r2);
        else
            return false;
    }
    
    public Dimension getPreferredSize()
    {
        if (getShape() != null || getBackImage() != null)
            return super.getPreferredSize();
        Dimension d = getLayout().preferredLayoutSize(getParent());
        FontMetrics fm = getFontMetrics(getFont());
        int height = d.height + fm.getHeight() + V_MARGIN * 2;
        int width = Math.max(d.width, fm.stringWidth(getLabel()) + H_MARGIN * 4);
        return new Dimension(width, height);
    }
}

