/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/************************************************************
 * ContainerGraphNode.java
 ************************************************************/
 
package utilities;

import java.awt.*;
import java.io.*;
import java.util.*;
import java.lang.*;
import javax.swing.*;

/**
 * This is a subclass of GraphNode, for the purpose of nodes that have
 *  an actual real world physical shape.
 *  Example:  a room, that exists as a node in a graph, but needs to 
 *  also have a physical size and location, etc.
 */
 
public class ContainerGraphNode extends GraphNode implements Serializable, Cloneable
{
  protected Hashtable contained = new Hashtable();
  boolean physical = false;
  
  /**
   * Default constructor.
   * @param l the label of the node
   */
  public ContainerGraphNode(String l)
  {
      super(l);
  }
  
  /**
   * Blank constructor.
   * Blank label, blank soul
   */
  public ContainerGraphNode()
  {
      this("");
  }
  
  public Enumeration getContained()
  {
      return contained.keys();
  }
 
  public Enumeration getPanels()
  {
      return contained.elements();
  }
  
  public void addContained(JPanel panel, GraphNode n, JPanel p)
  {
      if (p == null)
          p = n.getDefaultPanel();
      if (p instanceof NodePanel)
          ((NodePanel)p).setLabel(n.getLabel());
      contained.put(n, p);
      panel.add(p, n);
      panel.revalidate();
  }
  
  public void addContained(JPanel panel, GraphNode n)
  {
      addContained(panel, n, null);
  }
   
  public void removeContained(JPanel panel, GraphNode n)
  {
      panel.remove((JPanel)contained.get(n));
      contained.remove(n);
  }
  
  public boolean matches(GraphNode n)
  {
      if (n == null)
          return true;
      if (n instanceof ContainerGraphNode)
          return super.matches(n);
      return false;
  }
  
  public Object clone()
  {
      ContainerGraphNode cloned = null;
      
      try {
          cloned = (ContainerGraphNode) super.clone();
      } catch (Exception e) {System.out.println("Clone Error: " + e); }
      return cloned;
  }
    
  /***************************
   *        Drawing          *
   ***************************/
  
  public JPanel getDefaultPanel()
  {
      JPanel panel;
      GraphLayout temp = new GraphLayout(0, 1);
      temp.setSpacing(50, 25, 50, 25, NodePanel.H_MARGIN, NodePanel.V_MARGIN);
      temp.setSave(false);
      temp.setRecursivePlacement(false);
      panel = new ContainerNodePanel(this, getLabel());
      panel.setLayout(temp);
      return panel;
  }
}
