/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 *	Clock.java
 ***************************************************************************************/
package utilities;

/* Global Inclues */
import java.io.*;
import java.util.*;
import java.awt.*;

/* Local Includes */
import utilities.Log;

/**
 * Keeps track of the simulation time
 */
public class Clock {
	private	static Clock	clock = new Clock();
	private static int 	TICKS;
        private static Label timeLabel;
        private Log logger;
	
	/**
	 * Constructor, but no one else can make one of these
	 */
	private Clock() { 
	  timeLabel = new Label("Time: 0");
        }

	/**
	 * Returns the simulation clock
	 */
	public static Clock getClock() {
		return clock;
	}

	/**
	 * Resets the clock
	 */
	public static void reset() {
		Log.getDefault().log("(Clock) Resetting the clock.", 1);
		setTime(0);
	}

	/**
	 * Increments the clock.  This should be called by non-simulator
	 * objects, such as an agent.
	 */
	public synchronized static void tick() {
	  Log.getDefault().log("(Clock) Tick", 1);
	  setTime(TICKS + 1);
	}

  /**
   * Sets the time
   * @param t The time
   */
  public static void setTime(int t) {
    TICKS = t;
    timeLabel.setText("Time: " + TICKS);
  }

	/**
	 * Returns the current time
	 * @return The time
	 */
	public static int getTime() {
		return TICKS;
	}

  /**
   * Gets the clocks component label
   * @return The label
   */
  public Label getLabel() {
    return timeLabel;
  }
}
























