/* Copyright (C) 2005, University of Massachusetts, Multi-Agent Systems Lab
 * See LICENSE for license information
 */

/***************************************************************************************
 * Base64.java
 ***************************************************************************************/

package utilities;

import java.io.*;

/**
 * This was largely nabbed from the Bond project at the Computer Science Department
 * of Purdue (http://bond.cs.purdue.edu).  Hopefully I'm not stepping on toes.
 */
public class Base64 {

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer();
        for(int i = 0; i < raw.length; i+=3){
            encoded.append(encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = (slack >=2)? 2 : slack;

        for(int i = 0; i<=end; i++){
            byte b = raw[offset+i];
            int neuter = (b<0)? b+256 : b;
            block +=neuter << (8*(2-i));
        }
        char[] base64 = new char[4];
        for(int i=0; i<4; i++){
            int sixbit = (block >>>(6*(3-i)))&0x3f;
            base64[i] = getChar(sixbit);
        }
        if( slack <1)base64[2] = '=';
        if( slack <2)base64[3] = '=';
        return base64;
    }

    protected static char getChar(int sixbit) {
        if( sixbit >=0 && sixbit <=25)
            return (char)('A'+sixbit);
        if( sixbit >=26 && sixbit <=51)
            return (char)('a'+(sixbit-26));
        if( sixbit >=52 && sixbit <=61)
            return (char)('0'+(sixbit-52));
        if( sixbit == 62 ) return '+';
        if( sixbit == 63 ) return '/';
        return '?';
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        for( int i= base64.length()-1; base64.charAt(i)=='='; i--)
        pad ++;
        int length = base64.length()*6/8 - pad;
        byte[] raw = new byte[length];
        int rawindex =0;
        for(int i=0; i < base64.length(); i+=4){
            int block = (getValue(base64.charAt(i))<<18)
                +(getValue(base64.charAt(i+1))<<12)
                +(getValue(base64.charAt(i+2))<<6)
                +(getValue(base64.charAt(i+3)));
            for(int j=0; j<3 && rawindex+j < raw.length; j++)
                raw[rawindex+j] = (byte)((block >>(8*(2-j)))&0xff);
            rawindex +=3;
        }
        return raw;
    }

    protected static int getValue(char c) {
        if( c>='A' && c<='Z') return c-'A';
        if( c>='a' && c<='z') return c-'a'+26;
        if( c>='0' && c<='9') return c-'0'+52;
        if( c == '+') return 62;
        if( c == '/') return 63;
        if( c == '=') return 0;
        return -1;
    }

    public static Object stringToObject(String s) {

        byte[] snbytes=null;
        snbytes = Base64.decode(s);

        ByteArrayInputStream byteStream = new ByteArrayInputStream(snbytes);
        try {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(byteStream));

            return (Object)is.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String objectToString(Object o) {

        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(32000);
        try {
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(byteStream));
            os.flush();
            os.writeObject(o);
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }

        byte[] objectBuf = byteStream.toByteArray();
        String mdstring = Base64.encode(objectBuf);

        return mdstring;
    }
}
