/*
 * Decompiled with CFR 0.152.
 */
package utilities.cfg;

import java.awt.Point;
import utilities.cfg.CfgSection;

public class CfgItem {
    String name;
    Object value;
    CfgSection section;
    protected static final boolean quote_vs_escape = true;

    public CfgItem(String n, Object v) {
        this.name = n.toLowerCase();
        this.value = v;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        if (o != null) {
            this.value = o;
        }
    }

    protected String encode(String input) {
        StringBuffer b = new StringBuffer(input);
        boolean needsquoting = false;
        block4: for (int i = 0; i < b.length(); ++i) {
            switch (b.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    needsquoting = true;
                    continue block4;
                }
                case '\"': 
                case '\\': {
                    b.insert(i++, "\\");
                    continue block4;
                }
            }
        }
        if (needsquoting) {
            b.insert(0, "\"");
            b.insert(b.length(), "\"");
        }
        return b.toString();
    }

    protected String indent(int level, String s) {
        if (level == 0) {
            return s;
        }
        StringBuffer b = new StringBuffer();
        while (level-- > 0) {
            b.append("    ");
        }
        b.append(s);
        b.append("\n");
        return b.toString();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.toStringBuffer(b, 0);
        return b.toString();
    }

    protected void toStringBuffer(StringBuffer b, int level) {
        if (b == null) {
            return;
        }
        if (this.getValue() instanceof Point) {
            b.append(this.indent(level, this.encode(this.getName()) + " " + ((Point)this.getValue()).x + "," + ((Point)this.getValue()).y));
        } else if (this.getValue() instanceof CfgSection) {
            b.append(this.indent(level, this.encode(this.getName()) + " "));
            ((CfgSection)this.getValue()).toStringBuffer(b, level);
        } else {
            b.append(this.indent(level, this.encode(this.getName()) + " " + this.encode(this.getValue().toString())));
        }
    }
}

