/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VFlowLayout
extends FlowLayout {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    int align;
    int hgap;
    int vgap;
    boolean fill;

    public VFlowLayout() {
        this(1, 5, 5, true);
    }

    public VFlowLayout(boolean fill) {
        this(1, 5, 5, fill);
    }

    public VFlowLayout(int align) {
        this(align, 5, 5, true);
    }

    public VFlowLayout(int align, boolean fill) {
        this(align, 5, 5, fill);
    }

    public VFlowLayout(int align, int hgap, int vgap, boolean fill) {
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
        this.fill = fill;
    }

    public Dimension preferredLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            tarsiz.width = Math.max(tarsiz.width, d.width);
            if (i > 0) {
                tarsiz.height += this.hgap;
            }
            tarsiz.height += d.height;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.hgap * 2;
        tarsiz.height += insets.top + insets.bottom + this.vgap * 2;
        return tarsiz;
    }

    public Dimension minimumLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getMinimumSize();
            tarsiz.width = Math.max(tarsiz.width, d.width);
            if (i > 0) {
                tarsiz.height += this.vgap;
            }
            tarsiz.height += d.height;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.hgap * 2;
        tarsiz.height += insets.top + insets.bottom + this.vgap * 2;
        return tarsiz;
    }

    private void placethem(Container target, int x, int y, int width, int height, int first, int last) {
        if (this.align == 1) {
            y += height / 2;
        }
        if (this.align == 2) {
            y += height;
        }
        for (int i = first; i < last; ++i) {
            Component m = target.getComponent(i);
            Dimension md = m.getSize();
            if (!m.isVisible()) continue;
            int px = x + (width - md.width) / 2;
            m.setLocation(x + (width - md.width) / 2, y);
            y += this.vgap + md.height;
        }
    }

    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int maxwidth = target.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int numcomp = target.getComponentCount();
        int x = insets.left + this.hgap;
        int y = 0;
        int colw = 0;
        int start = 0;
        for (int i = 0; i < numcomp; ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            if (this.fill) {
                m.setSize(maxwidth, d.height);
                d.width = maxwidth;
            } else {
                m.setSize(d.width, d.height);
            }
            if (y > maxheight) {
                this.placethem(target, x, insets.top + this.vgap, colw, maxheight - y, start, i);
                y = d.height;
                x += this.hgap + colw;
                colw = d.width;
                start = i;
                continue;
            }
            if (y > 0) {
                y += this.vgap;
            }
            y += d.height;
            colw = Math.max(colw, d.width);
        }
        this.placethem(target, x, insets.top + this.vgap, colw, maxheight - y, start, numcomp);
    }
}

