/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.Hashtable;

public class UTimer {
    protected long started = 0L;
    protected long stopped = 0L;
    protected boolean running = false;
    protected boolean completed = false;
    protected Boolean access = new Boolean(true);
    protected String name = "";
    protected int window = -1;
    protected int windowcounter = 0;
    protected boolean windowed = false;
    protected double[] data = null;
    protected static Hashtable timers = new Hashtable();

    public static UTimer getTimer(String s) {
        if (timers.contains(s)) {
            return (UTimer)timers.get(s);
        }
        UTimer t = new UTimer(s);
        timers.put(s, t);
        return t;
    }

    public static void clearTimer(String s) {
        timers.remove(s);
    }

    public static long time(int count, UTimer t, boolean windowed) {
        if (windowed) {
            t.setWindowed(true, count);
        } else {
            t.setWindowed(false, 0);
        }
        return UTimer.time(count, t);
    }

    public static long time(int count, UTimer t) {
        while (count > 0) {
            t.startTimer();
            t.action();
            t.stopTimer();
            --count;
        }
        System.out.println(t);
        return t.getTime();
    }

    public static long time(UTimer t) {
        return UTimer.time(1, t);
    }

    public UTimer(String n) {
        this.name = n;
    }

    public UTimer(String n, int window) {
        this(n);
        this.setWindowed(true, window);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void setWindowed(boolean b, int w) {
        this.windowed = b;
        if (this.windowed) {
            this.window = w;
            this.data = new double[w];
            this.resetWindow();
        } else {
            this.data = null;
        }
    }

    public int getWindow() {
        return this.window;
    }

    public void resetWindow() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Double.MIN_VALUE;
        }
        this.windowcounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (this.running) {
                System.err.println("cannot start timer " + this);
                return;
            }
            if (this.windowed) {
                this.started = System.currentTimeMillis();
                this.running = true;
                this.completed = false;
            } else if (!this.windowed) {
                this.started = System.currentTimeMillis() - this.getTime();
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stopTimer() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (this.running) {
                this.stopped = System.currentTimeMillis();
                if (this.windowed) {
                    this.data[this.windowcounter++] = this.stopped - this.started;
                    if (this.windowcounter > this.window) {
                        this.windowcounter = 0;
                    }
                }
                this.running = false;
                this.completed = true;
                return this.getTime();
            }
            System.err.println("cannot stop timer " + this);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimer() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (this.windowed) {
                this.resetWindow();
            }
            this.windowcounter = 0;
            this.running = false;
            this.completed = false;
            this.stopped = 0L;
            this.started = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTime() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (!this.running && this.completed) {
                return this.stopped - this.started;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverage() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (!this.windowed) {
                return this.getTime();
            }
            double avg = 0.0;
            int count = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == Double.MIN_VALUE) continue;
                avg = (avg * (double)count + this.data[i]) / (double)(++count);
            }
            return avg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Boolean bl = this.access;
        synchronized (bl) {
            if (!this.windowed) {
                return 1;
            }
            int count = 0;
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == Double.MIN_VALUE) continue;
                ++count;
            }
            return count;
        }
    }

    public String toString() {
        String s = new String("[ " + this.name + ": ");
        if (this.running) {
            long l = System.currentTimeMillis();
            s = new String(s + "been running for [" + this.started + "ms] ");
        } else {
            s = this.completed ? (this.isWindowed() ? new String(s + "average time [" + this.getAverage() + "ms] count [" + this.getCount() + "] ") : new String(s + "time [" + this.getTime() + "ms] ")) : new String(s + "not running");
        }
        s = new String(s + "]");
        return s;
    }

    public void action() {
    }
}

