/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.Random;
import utilities.Distribution;
import utilities.Log;

public class TaemsRandom {
    private static TaemsRandom defaultRandom;
    private float[] distribution;
    private long seed;
    private Random Rg;
    private int base;
    private int sum;
    private static Log logger;

    public TaemsRandom(long seed) {
        logger = Log.getDefault();
        this.seed = seed;
        this.Rg = new Random(this.seed);
        logger.log("(Random Generator) Random seed sets to " + this.getSeed() + " (given)");
    }

    public TaemsRandom() {
        logger = Log.getDefault();
        this.seed = System.currentTimeMillis();
        this.Rg = new Random(this.seed);
        logger.log("(Random Generator) Random seed sets to " + this.getSeed() + " (time depending)");
    }

    public void setDistribution(Distribution d) {
        this.setDistribution(d.getArray());
    }

    public synchronized void setDistribution(float[] args) {
        int i;
        while (this.distribution != null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        float[] tmp = new float[args.length / 2];
        this.base = 1;
        for (i = 0; i < args.length; ++i) {
            while (!this.isAnInteger(args[i] * (float)this.base)) {
                this.base *= 10;
                logger.log("(Random Generator) New base : " + this.base, 3);
            }
            tmp[i / 2] = args[i];
            ++i;
        }
        this.sum = 0;
        for (i = 0; i < tmp.length; ++i) {
            this.sum = (int)Math.rint((double)tmp[i] * (double)this.base) + this.sum;
        }
        logger.log("(Random Generator) base = " + this.base + " and total sum on " + this.sum, 3);
        this.distribution = new float[this.sum];
        if (args.length != 0) {
            int pointeur = 0;
            for (i = 0; i < args.length; ++i) {
                int max = pointeur + (int)Math.rint((double)this.base * (double)args[i]);
                logger.log("(Random Generator) from " + (pointeur + 1) + " to " + max + " Value = " + args[i + 1], 3);
                int j = pointeur;
                while (j < max) {
                    this.distribution[j] = args[i + 1];
                    ++j;
                    ++pointeur;
                }
                ++i;
            }
        }
    }

    public synchronized void unsetDistribution() {
        this.distribution = null;
        this.base = 0;
        this.sum = 0;
        this.notifyAll();
    }

    public int nextInt() {
        if (this.base != 0) {
            Float f = new Float((float)this.sum * this.Rg.nextFloat());
            logger.log("(Random Generator) Index choosen : " + f.intValue(), 3);
            return f.intValue();
        }
        logger.log("(Random Generator) Error try to access to random distribution without distribution set !");
        return 0;
    }

    public float nextFloat() {
        if (this.Rg != null) {
            return this.Rg.nextFloat();
        }
        logger.log("(Random Generator) Error try to access to random number without initialization !");
        return 0.0f;
    }

    public double nextGaussian() {
        if (this.Rg != null) {
            return this.Rg.nextGaussian();
        }
        logger.log("(Random Generator) Error try to access to random number without initialization !");
        return 0.0;
    }

    public float nextValue() {
        if (this.base != 0) {
            float f = this.distribution[this.nextInt()];
            logger.log("(Random Generator) Value at this index : " + f, 3);
            return f;
        }
        logger.log("(Random Generator) Error try to access to random distribution without distribution set !");
        return 0.0f;
    }

    public boolean isAnInteger(float value) {
        return Math.ceil(value) - (double)value <= 1.0E-4;
    }

    public long getSeed() {
        return this.seed;
    }

    public long getUniqID() {
        return this.Rg.nextLong();
    }

    public static synchronized void setDefault(TaemsRandom r) {
        defaultRandom = r;
        logger.log("(Random Generator) Random Generator available");
    }

    public static TaemsRandom getDefault() {
        return defaultRandom;
    }
}

