/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Graphics;
import java.awt.Point;
import utilities.Curve;

public class Spline {
    public float[] Px;
    public float[] Py;
    public float[] Ax;
    public float[] Ay;
    public float[] Bx;
    public float[] By;
    public float[] Cx;
    public float[] Cy;
    public int NP;
    private float[] k;
    private float[][] Mat;

    public Spline(float[] Px, float[] Py, int NP) {
        this.Px = new float[NP];
        this.Py = new float[NP];
        for (int i = 0; i < NP; ++i) {
            this.Px[i] = Px[i];
            this.Py[i] = Py[i];
        }
        this.Ax = new float[NP - 1];
        this.Ay = new float[NP - 1];
        this.Bx = new float[NP];
        this.By = new float[NP];
        this.Cx = new float[NP - 1];
        this.Cy = new float[NP - 1];
        this.NP = NP;
        this.k = new float[NP - 1];
        this.Mat = new float[NP][3];
    }

    public Spline(int[] Px, int[] Py, int NP) {
        this.Px = new float[NP];
        this.Py = new float[NP];
        for (int i = 0; i < NP; ++i) {
            this.Px[i] = Px[i];
            this.Py[i] = Py[i];
        }
        this.Ax = new float[NP - 1];
        this.Ay = new float[NP - 1];
        this.Bx = new float[NP];
        this.By = new float[NP];
        this.Cx = new float[NP - 1];
        this.Cy = new float[NP - 1];
        this.NP = NP;
        this.k = new float[NP - 1];
        this.Mat = new float[NP][3];
    }

    public void Generate() {
        int i;
        for (i = 0; i <= this.NP - 2; ++i) {
            this.Ax[i] = this.Px[i + 1] - this.Px[i];
            this.Ay[i] = this.Py[i + 1] - this.Py[i];
        }
        float AMagOld = (float)Math.sqrt(this.Ax[0] * this.Ax[0] + this.Ay[0] * this.Ay[0]);
        for (i = 0; i <= this.NP - 3; ++i) {
            float AMag = (float)Math.sqrt(this.Ax[i + 1] * this.Ax[i + 1] + this.Ay[i + 1] * this.Ay[i + 1]);
            this.k[i] = AMagOld / AMag;
            AMagOld = AMag;
        }
        this.k[this.NP - 2] = 1.0f;
        for (i = 1; i <= this.NP - 2; ++i) {
            this.Mat[i][0] = 1.0f;
            this.Mat[i][1] = 2.0f * this.k[i - 1] * (1.0f + this.k[i - 1]);
            this.Mat[i][2] = this.k[i - 1] * this.k[i - 1] * this.k[i];
        }
        this.Mat[0][1] = 2.0f;
        this.Mat[0][2] = this.k[0];
        this.Mat[this.NP - 1][0] = 1.0f;
        this.Mat[this.NP - 1][1] = 2.0f * this.k[this.NP - 2];
        for (i = 1; i <= this.NP - 2; ++i) {
            this.Bx[i] = 3.0f * (this.Ax[i - 1] + this.k[i - 1] * this.k[i - 1] * this.Ax[i]);
            this.By[i] = 3.0f * (this.Ay[i - 1] + this.k[i - 1] * this.k[i - 1] * this.Ay[i]);
        }
        this.Bx[0] = 3.0f * this.Ax[0];
        this.By[0] = 3.0f * this.Ay[0];
        this.Bx[this.NP - 1] = 3.0f * this.Ax[this.NP - 2];
        this.By[this.NP - 1] = 3.0f * this.Ay[this.NP - 2];
        this.MatrixSolve(this.Bx);
        this.MatrixSolve(this.By);
        for (i = 0; i <= this.NP - 2; ++i) {
            this.Cx[i] = this.k[i] * this.Bx[i + 1];
            this.Cy[i] = this.k[i] * this.By[i + 1];
        }
    }

    private void MatrixSolve(float[] B) {
        int i;
        float[] Work = new float[this.NP];
        float[] WorkB = new float[this.NP];
        for (i = 0; i <= this.NP - 1; ++i) {
            Work[i] = B[i] / this.Mat[i][1];
            WorkB[i] = Work[i];
        }
        for (int j = 0; j < 10; ++j) {
            int i2;
            Work[0] = (B[0] - this.Mat[0][2] * WorkB[1]) / this.Mat[0][1];
            for (i2 = 1; i2 < this.NP - 1; ++i2) {
                Work[i2] = (B[i2] - this.Mat[i2][0] * WorkB[i2 - 1] - this.Mat[i2][2] * WorkB[i2 + 1]) / this.Mat[i2][1];
            }
            Work[this.NP - 1] = (B[this.NP - 1] - this.Mat[this.NP - 1][0] * WorkB[this.NP - 2]) / this.Mat[this.NP - 1][1];
            for (i2 = 0; i2 <= this.NP - 1; ++i2) {
                WorkB[i2] = Work[i2];
            }
        }
        for (i = 0; i <= this.NP - 1; ++i) {
            B[i] = Work[i];
        }
    }

    public void draw(Graphics gra) {
        Curve c = new Curve();
        for (int i = 0; i < this.NP - 1; ++i) {
            c.PutCurve(this.Ax[i], this.Ay[i], this.Bx[i], this.By[i], this.Cx[i], this.Cy[i]);
            c.draw(gra, this.Px[i], this.Py[i]);
        }
    }

    public Point getPoint(float dist) {
        Curve c = new Curve();
        float x = (float)(this.NP - 1) * dist;
        int i = (int)x;
        float d = x - (float)i;
        c.PutCurve(this.Ax[i], this.Ay[i], this.Bx[i], this.By[i], this.Cx[i], this.Cy[i]);
        return c.getPoint(d, this.Px[i], this.Py[i]);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.NP - 1; ++i) {
            s = s + "[" + this.Px[i] + ", " + this.Py[i] + "]";
            if (i >= this.NP - 2) continue;
            s = s + ", ";
        }
        return s;
    }

    public void show() {
        for (int i = 0; i < this.NP - 1; ++i) {
            System.out.println(this.Ax[i] + "," + this.Ay[i] + "," + this.Bx[i] + "," + this.By[i] + "," + this.Cx[i] + "," + this.Cy[i]);
            System.out.println(this.Px[i] + "," + this.Py[i]);
        }
    }
}

