/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import utilities.Embedding;

public class SimpleEmbedding
implements Embedding {
    Set nodes;
    Set edges;
    Map edge_orderings;
    Map minimum_angles;

    public SimpleEmbedding(Set nodes, Set edges) {
        this.setGraph(nodes, edges);
    }

    public void setGraph(Set n, Set e) {
        this.nodes = n;
        Iterator i = e.iterator();
        this.edges = new HashSet();
        while (i.hasNext()) {
            List l = (List)i.next();
            this.edges.add(new EdgeList(l));
        }
        this.produceOrdering();
    }

    public Iterator getNodes() {
        return this.edge_orderings.keySet().iterator();
    }

    public Iterator getEdges() {
        return this.edges.iterator();
    }

    public Iterator getEdgeOrderings() {
        return this.edge_orderings.values().iterator();
    }

    public Iterator getMinimumAngles() {
        return this.minimum_angles.values().iterator();
    }

    public Iterator getEdgeOrder(Object node) {
        return ((List)this.edge_orderings.get(node)).iterator();
    }

    public int getMinimumAngle(Object node) {
        return (Integer)this.minimum_angles.get(node);
    }

    protected synchronized void produceOrdering() {
        Iterator i = this.getNodes();
        this.edge_orderings = new TreeMap();
        this.minimum_angles = new TreeMap();
        while (i.hasNext()) {
            Object o = i.next();
            this.edge_orderings.put(o, new Vector());
            this.minimum_angles.put(o, new Integer(10));
        }
        i = this.getEdges();
        while (i.hasNext()) {
            EdgeList edge = new EdgeList((List)i.next());
            List node1 = (List)this.edge_orderings.get(edge.get(0));
            List node2 = (List)this.edge_orderings.get(edge.get(1));
            if (!node1.contains(edge)) {
                node1.add(edge);
            }
            if (node2.contains(edge)) continue;
            node2.add(edge);
        }
    }

    protected boolean edgeEquals(List edge1, List edge2) {
        if (edge1.get(0) == edge2.get(0) && edge1.get(1) == edge2.get(1)) {
            return true;
        }
        return edge1.get(0) == edge2.get(1) && edge1.get(2) == edge2.get(0);
    }

    protected class EdgeList
    extends Vector {
        public EdgeList(List l) {
            this(l.get(0), l.get(1));
        }

        public EdgeList(Object e1, Object e2) {
            this.add(e1);
            this.add(e2);
        }

        public boolean equals(Object o) {
            if (o instanceof EdgeList) {
                EdgeList edge = (EdgeList)o;
                if (edge.get(0) == this.get(0) && edge.get(1) == this.get(1)) {
                    return true;
                }
                if (edge.get(0) == this.get(1) && edge.get(2) == this.get(0)) {
                    return true;
                }
            }
            return false;
        }
    }
}

