/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import utilities.GraphLayers;
import utilities.GraphNode;
import utilities.ImageComponent;
import utilities.cfg.CfgManager;
import utilities.cfg.ConfiguredObject;

public class NodePanel
extends JPanel
implements ConfiguredObject {
    protected String label = "";
    protected boolean selected = false;
    protected boolean nodefilled = true;
    protected boolean moveable = true;
    protected Shape shape = null;
    public static int H_MARGIN = 5;
    public static int V_MARGIN = 2;
    public static Font normalFont = new Font("SansSerif", 0, 12);
    public static Font smallFont = new Font("SansSerif", 0, 8);
    GraphNode parent;
    ImageComponent bg_image = null;
    URL bg_image_url = null;

    public NodePanel(GraphNode n, String l) {
        this.setNode(n);
        this.setLabel(l);
        this.setLayout(null);
    }

    protected NodePanel() {
        this(null, null);
    }

    public GraphNode getNode() {
        return this.parent;
    }

    protected void setNode(GraphNode n) {
        this.parent = n;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public boolean isNodeFilled() {
        return this.nodefilled;
    }

    public void setNodeFilled(boolean b) {
        this.nodefilled = b;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean b) {
        this.moveable = b;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackImage(g);
        g.setFont(normalFont);
        FontMetrics fm = g.getFontMetrics();
        Rectangle rect = this.getBounds();
        rect = new Rectangle(0, 0, rect.width - 1, rect.height - 1);
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(this.getBackground());
        }
        if (this.isNodeFilled()) {
            g.fillRoundRect(0, 0, rect.width, rect.height, this.getRectRoundness(), this.getRectRoundness());
        }
        g.setColor(Color.black);
        g.drawRoundRect(0, 0, rect.width, rect.height, this.getRectRoundness(), this.getRectRoundness());
        try {
            g.setColor(this.getForeground());
            g.drawString(this.getLabel(), rect.x + H_MARGIN, rect.y + rect.height - (V_MARGIN + fm.getDescent()));
        }
        catch (NullPointerException e) {
            System.err.println("Error drawing label");
            e.printStackTrace();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(25, 25);
    }

    public Dimension getPreferredSize() {
        if (this.bg_image != null) {
            return this.bg_image.getPreferredSize();
        }
        if (this.getShape() != null) {
            return this.getShape().getBounds().getSize();
        }
        return this.calculateSize(this.getFontMetrics(this.getFont()));
    }

    public void setBackImage(ImageComponent i) {
        this.bg_image = i;
        this.bg_image_url = null;
        if (this.bg_image == null) {
            this.setNodeFilled(true);
        } else {
            this.bg_image.setLocation(this.getLocation());
            this.setPreferredSize(this.bg_image.getPreferredSize());
            this.setNodeFilled(false);
        }
    }

    public void setBackImage(URL u) {
        this.setBackImage(new ImageComponent(u));
        this.bg_image_url = u;
    }

    public URL getBackImageURL() {
        return this.bg_image_url;
    }

    public ImageComponent getBackImage() {
        if (GraphLayers.getGlobal().isVisible("geographic")) {
            return this.bg_image;
        }
        return null;
    }

    public void paintBackImage(Graphics g) {
        if (this.bg_image == null) {
            return;
        }
        this.bg_image.setLocation(this.getLocation());
        this.bg_image.paint(g);
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape s) {
        if (s instanceof Polygon) {
            throw new IllegalArgumentException();
        }
        if (s instanceof Rectangle) {
            this.shape = ((Rectangle)s).getBounds();
            this.setLocation(((Rectangle)this.shape).getLocation());
            this.setSize(new Dimension(this.shape.getBounds().x, this.shape.getBounds().y));
            this.setMoveable(false);
        }
    }

    public int calculateHeight(FontMetrics fm) {
        if (this.getLabel() == null) {
            return 0;
        }
        return fm.getHeight() + V_MARGIN * 2;
    }

    public int calculateWidth(FontMetrics fm) {
        if (this.getLabel() == null) {
            return 0;
        }
        return fm.stringWidth(this.getLabel()) + H_MARGIN * 2;
    }

    public Dimension calculateSize(FontMetrics fm) {
        return new Dimension(this.calculateWidth(fm), this.calculateHeight(fm));
    }

    public Color getBackground() {
        return Color.white;
    }

    public Color getForeground() {
        return Color.black;
    }

    public int getRectRoundness() {
        return 0;
    }

    public Point getLocationForLine() {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        return new Point(p.x + d.width / 2, p.y + d.height / 2);
    }

    public Point getLocationForLine(GraphNode src) {
        return this.getLocationForLine();
    }

    public synchronized void updateCfg() {
        Boolean b;
        CfgManager manager = CfgManager.getManager(this);
        if (manager == null) {
            System.err.println("NodePanel " + this.getLabel() + "has no cfg manager...");
            return;
        }
        String key = manager.getObjectKey(this);
        if (key == null || key.length() == 0) {
            return;
        }
        String s = manager.getStringValue(key + "/name");
        if (s != null) {
            this.setLabel(s);
        }
        if ((b = manager.getBooleanValue(key + "/nodefilled")) != null) {
            this.setNodeFilled(b);
        }
        if ((b = manager.getBooleanValue(key + "/moveable")) != null) {
            this.setMoveable(b);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        Integer i = manager.getIntegerValue(key + "/height");
        if (i != null) {
            height = i;
        }
        if ((i = manager.getIntegerValue(key + "/width")) != null) {
            width = i;
        }
        this.setSize(width, height);
        Point p = manager.getPointValue(key + "/upleft");
        if (p != null) {
            this.setLocation(p);
        }
        if ((s = manager.getStringValue(key + "/background")) != null) {
            try {
                this.setBackImage(new URL(s));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    public synchronized void saveCfg() {
        CfgManager manager = CfgManager.getManager(this);
        if (manager == null) {
            System.err.println("NodePanel " + this.getLabel() + "has no cfg manager...");
            return;
        }
        String key = manager.getObjectKey(this);
        if (key == null || key.length() == 0) {
            return;
        }
        manager.put(key + "/name", this.getLabel());
        manager.put(key + "/nodefilled", this.isNodeFilled());
        manager.put(key + "/moveable", this.isMoveable());
        manager.put(key + "/upleft", this.getLocation());
        Dimension d = this.getSize();
        manager.put(key + "/width", this.getWidth());
        manager.put(key + "/height", this.getHeight());
        if (this.getBackImageURL() != null) {
            manager.put(key + "/background", this.getBackImageURL().toString());
        }
    }
}

