/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import utilities.Connection;

public class Message
implements Cloneable {
    protected static final String MSG_DELIM = "\r\nEOM\r\n";
    protected static final int MSG_WINDOW = 100;
    private Object content;
    private String sourceaddr = "";
    private String destaddr = "";
    private int sourceport = -1;
    private int destport = -1;
    private int sendtime = -1;
    private int receivetime = -1;
    private String data = "";
    private Connection connection;

    public Message() {
    }

    public Message(Object c) {
        this(c, null, -1, null, -1);
    }

    public Message(Object c, String da, int dp) {
        this(c, null, -1, da, dp);
    }

    public Message(Object c, String sa, int sp, String da, int dp) {
        this.content = c;
        this.sourceaddr = sa;
        this.sourceport = sp;
        this.destaddr = da;
        this.destport = dp;
        this.data = c.toString();
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object c) {
        this.content = c;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String d) {
        this.data = d;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection c) {
        this.connection = c;
    }

    public String getSourceAddr() {
        return this.sourceaddr;
    }

    public void setSourceAddr(String sa) {
        this.sourceaddr = sa;
    }

    public int getSourcePort() {
        return this.sourceport;
    }

    public void setSourcePort(int sp) {
        this.sourceport = sp;
    }

    public String getDestAddr() {
        return this.destaddr;
    }

    public void setDestAddr(String da) {
        this.destaddr = da;
    }

    public int getDestPort() {
        return this.destport;
    }

    public void setDestPort(int dp) {
        this.destport = dp;
    }

    public int getSendTime() {
        return this.sendtime;
    }

    public void setSendTime(int t) {
        this.sendtime = t;
    }

    public int getReceiveTime() {
        return this.receivetime;
    }

    public void setReceiveTime(int t) {
        this.receivetime = t;
    }

    public String contentWord() {
        return this.contentWord(this.content.toString());
    }

    public String contentWord(String str) {
        StringTokenizer st = new StringTokenizer(str);
        if (st.hasMoreElements()) {
            return st.nextToken();
        }
        return new String("");
    }

    public String contentData() {
        return this.contentData(this.content.toString());
    }

    public String contentData(String str) {
        StringTokenizer st = new StringTokenizer(str);
        if (st.countTokens() > 1) {
            return str.substring(st.nextToken().length() + 1, str.length());
        }
        return new String("");
    }

    public boolean send(BufferedWriter b) {
        return this.send(b, MSG_DELIM);
    }

    public boolean send(BufferedWriter b, String d) {
        try {
            b.write(this.getData());
            if (this.getData().length() <= 0) {
                System.err.println("Warning: About to send empty message");
            }
            if (!this.getData().endsWith(d)) {
                b.write(d);
            }
            b.flush();
        }
        catch (IOException e) {
            System.err.println("Error sending message: " + e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String receive(BufferedReader b, String d) {
        String str;
        char[] bufr = new char[100];
        StringBuffer strb = new StringBuffer();
        int total = 0;
        try {
            int goodlen = 100 - d.length();
            while (true) {
                BufferedReader bufferedReader = b;
                synchronized (bufferedReader) {
                    int time = 0;
                    if (!b.ready()) {
                        time += 10;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (time > 3000) {
                            System.err.println("Dangit, I was all set to read in some data and they psyched me! (I'm probably deadlocked now)");
                        }
                    }
                    b.mark(100);
                    int len = b.read(bufr, 0, 100);
                    if (len == -1) {
                        break;
                    }
                    b.reset();
                    if (String.valueOf(bufr, 0, len).indexOf(d) >= 0) {
                        goodlen = String.valueOf(bufr).indexOf(d) + d.length();
                        len = b.read(bufr, 0, goodlen);
                        strb.append(bufr, 0, len);
                        break;
                    }
                    len = b.read(bufr, 0, goodlen);
                    total += len;
                    strb.append(bufr, 0, len);
                }
            }
            str = new String(strb);
        }
        catch (IOException e) {
            System.err.println("Error receiving message: " + e);
            return null;
        }
        if (str.indexOf(d) >= 0) {
            if ((str = str.substring(0, str.indexOf(d))).length() <= 0) {
                System.err.println("Warning: Received empty message");
            }
            return str;
        }
        System.err.println("Error receiving message: Delimiter (\r\nEOM\r\n) not found in message -\n" + str);
        return null;
    }

    public static String receive(BufferedReader b) {
        return Message.receive(b, MSG_DELIM);
    }

    public static String receive(BufferedReader b, int length) {
        String str;
        char[] bufr = new char[100];
        StringBuffer strb = new StringBuffer();
        try {
            int len;
            int goodlen = 100;
            for (int total = 0; total < length; total += len) {
                if (!b.ready()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (total + goodlen > length) {
                    goodlen = length - total;
                }
                len = b.read(bufr, 0, goodlen);
                if (len == -1) break;
                strb.append(bufr, 0, len);
            }
            str = new String(strb);
        }
        catch (IOException e) {
            System.err.println("Error receiving message: " + e);
            return null;
        }
        if (str.length() <= 0) {
            System.err.println("Warning: Received empty message");
        } else if (str.length() < length) {
            System.err.println("Warning: Did not meet the requested length");
        }
        return str;
    }

    public Object clone() {
        Message n = null;
        try {
            n = (Message)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        n.setContent(this.getContent());
        n.setSourceAddr(this.getSourceAddr());
        n.setDestAddr(this.getDestAddr());
        n.setSourcePort(this.getSourcePort());
        n.setDestPort(this.getDestPort());
        n.setSendTime(this.getSendTime());
        n.setReceiveTime(this.getReceiveTime());
        n.setConnection(this.getConnection());
        n.data = this.data;
        return n;
    }

    public String toString() {
        return "Message (from " + this.sourceaddr + ":" + this.sourceport + " at " + this.getSendTime() + ") (to " + this.destaddr + ":" + this.destport + " at " + this.getReceiveTime() + ") Data: \"" + this.getData() + "\"" + "  Content: \"" + this.getContent() + "\"";
    }
}

