/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

public class ImageComponent
extends Component {
    private Image image;
    private Dimension size;
    private MediaTracker tracker = new MediaTracker(this);

    public ImageComponent(Image i) {
        this.setImage(i);
    }

    public ImageComponent(URL u) {
        this.setImage(u);
    }

    public void setImage(URL u) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(u));
    }

    public void setImage(Image i) {
        this.image = i;
        MediaTracker m = new MediaTracker(this);
        this.tracker.addImage(this.image, 1);
        this.init();
        this.repaint();
    }

    public void init() {
        try {
            this.tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.size = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, this.getX(), this.getY(), this);
    }

    public Dimension getPreferredSize() {
        this.init();
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

