/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import utilities.ContainerGraphNode;
import utilities.ContainerNodePanel;
import utilities.Graph;
import utilities.GraphEdge;
import utilities.GraphNode;
import utilities.ImageComponent;
import utilities.NodePanel;
import utilities.cfg.CfgManager;

public class GraphTest
extends Panel
implements Runnable {
    private static final int INITIAL_WIDTH = 1000;
    private static final int INITIAL_HEIGHT = 400;

    public synchronized void run() {
        System.err.println("Test has started.\n");
        Graph graph = new Graph("GraphTest");
        final CfgManager manager = new CfgManager("graphtest.cfg");
        manager.addConfiguredObject(graph, "/graph");
        graph.addLayer("I am a layer");
        GraphNode test1 = new GraphNode("test 1");
        GraphNode test6 = new GraphNode("test 2");
        GraphNode test3 = new GraphNode("test 3");
        GraphEdge test4 = new GraphEdge("test 4", test1, test6);
        GraphEdge test5 = new GraphEdge("test 5", test6, test3);
        GraphNode bedroom = new GraphNode("Bedroom");
        bedroom.addEdge(test1);
        NodePanel bedroom_panel2 = new NodePanel();
        bedroom_panel2.setLabel("bedroom panel 2");
        test3.addEdge(test1);
        graph.addNode(test1);
        GraphEdge crosslayer = new GraphEdge(test1, bedroom);
        graph.setDefaultLayer("I am a layer");
        GraphNode bathroom = new GraphNode("Bathroom");
        GraphNode hallway = new GraphNode("Hallway");
        GraphNode livingroom = new GraphNode("Living Room");
        GraphNode kitchen = new GraphNode("Kitchen");
        ContainerGraphNode mind = new ContainerGraphNode("mind");
        ContainerGraphNode test = new ContainerGraphNode("test");
        GraphNode quit = new GraphNode("quit");
        graph.addNode(quit, new JPanel(), "default");
        JButton button = new JButton("quit");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.save();
                System.exit(0);
            }
        });
        graph.getLayers().getTopPanel(quit).add(button);
        graph.getLayers().getTopPanel(quit).revalidate();
        bedroom.addEdge(bathroom);
        bedroom.addEdge(hallway);
        livingroom.addEdge(hallway);
        livingroom.addEdge(kitchen);
        kitchen.addEdge(hallway);
        GraphEdge edgetest = new GraphEdge("test", mind, test);
        GraphNode watertank = new GraphNode("Water tank");
        GraphEdge pipe1 = new GraphEdge("pipe to bathroom", watertank, bathroom);
        GraphEdge pipe2 = new GraphEdge("pipe to kitchen", watertank, kitchen);
        watertank.addEdge(mind);
        GraphNode heater = new GraphNode("Water heater");
        GraphEdge pipe3 = new GraphEdge("pipe to water heater", watertank, heater);
        GraphEdge pipe4 = new GraphEdge("hot pipe to kitchen", heater, kitchen);
        GraphEdge pipe5 = new GraphEdge("hot pipe to bathroom", heater, bathroom);
        graph.addTree(bedroom);
        graph.addToLayer("default", bedroom, bedroom_panel2);
        GraphNode thoughts = new GraphNode("thoughts");
        GraphNode being = new GraphNode("being");
        ContainerNodePanel cpanel = (ContainerNodePanel)graph.getLayers().getPanel("I am a layer", mind);
        mind.addContained(cpanel, thoughts);
        mind.addContained(cpanel, being);
        cpanel.setShape(new Rectangle(20, 20, 200, 200));
        cpanel = (ContainerNodePanel)graph.getLayers().getPanel("I am a layer", test);
        cpanel.setShape(new Rectangle(100, 100, 150, 200));
        GraphNode test2 = new GraphNode("lots of little tests");
        test.addContained(cpanel, test2);
        test.addEdge(mind);
        try {
            cpanel.setBackImage(new ImageComponent(new URL("http://dis.cs.umass.edu/~rawlins/usa_map.jpg")));
        }
        catch (MalformedURLException e) {
            System.err.println("Unable to load image.");
        }
        cpanel.setLinkLocation("test", new Point(50, 50));
        System.err.println("******DISCLAIMER*******");
        System.err.println("This demo does NOTHING.  \nIt just looks like it does something.  \nDon't be fooled!");
        this.showGraph(graph);
    }

    public void showGraph(Graph g) {
        JFrame frame = new JFrame("GraphTest");
        frame.setSize(1000, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 500, screenSize.height / 2 - 200);
        frame.getContentPane().add((Component)g, "Center");
        frame.show();
    }

    public static void main(String[] args) {
        GraphTest test = new GraphTest();
        test.run();
    }
}

