/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import utilities.GraphLayer;
import utilities.GraphNode;
import utilities.cfg.ConfiguredObject;

public class GraphLayers
implements ConfiguredObject {
    Hashtable layers;
    Vector visible_layers;
    static GraphLayers global_hack = null;
    JTabbedPane panel = null;

    public static GraphLayers getGlobal() {
        return global_hack;
    }

    public GraphLayers(JTabbedPane p) {
        this.panel = p;
        this.layers = new Hashtable();
        this.visible_layers = new Vector();
        this.addLayer("default");
        global_hack = this;
    }

    public void addLayer(String name) {
        GraphLayer g = new GraphLayer(name);
        this.panel.addTab(name, g.getPanel());
        this.layers.put(name, g);
    }

    public void removeLayer(String name) {
        this.layers.remove(name);
        if (this.visible_layers.contains(name)) {
            this.visible_layers.removeElement(name);
        }
    }

    public void addToLayer(String name, GraphNode mem, JPanel panel) {
        GraphLayer g;
        if (!this.layers.containsKey(name)) {
            this.addLayer(name);
        }
        if (!(g = (GraphLayer)this.layers.get(name)).contains(mem)) {
            g.addToLayer(mem, panel);
        }
    }

    public void removeFromLayer(String name, GraphNode mem) {
        GraphLayer g;
        if (this.layers.containsKey(name) && (g = (GraphLayer)this.layers.get(name)).contains(mem)) {
            g.removeFromLayer(mem);
        }
    }

    public Enumeration getLayers() {
        return this.layers.keys();
    }

    public Enumeration getLayers(GraphNode mem) {
        Enumeration e = this.layers.keys();
        Enumeration f = this.layers.elements();
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            if (((GraphLayer)f.nextElement()).contains(mem)) {
                v.addElement(e.nextElement());
                continue;
            }
            e.nextElement();
        }
        return v.elements();
    }

    public void eliminate(GraphNode mem) {
        Enumeration e = this.getLayers(mem);
        while (e.hasMoreElements()) {
            this.removeFromLayer((String)e.nextElement(), mem);
        }
    }

    public String getVisible() {
        Enumeration e = this.getLayers();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (this.getLayer(s).getPanel() != this.panel.getSelectedComponent()) continue;
            return s;
        }
        return null;
    }

    public boolean isVisible(String name) {
        return true;
    }

    public void setVisible(String name, boolean b) {
        GraphLayer l = this.getLayer(name);
    }

    public boolean isObjectVisible(GraphNode mem) {
        String s = this.getVisible();
        return this.isInLayer(s, mem) && this.isVisible(s);
    }

    public JPanel getPanel(String layer, GraphNode n) {
        if (layer != null && this.isInLayer(layer, n)) {
            return this.getLayer(layer).getPanel(n);
        }
        return null;
    }

    public JPanel getTopPanel(GraphNode n) {
        String s = this.getVisible();
        if (s != null && this.isInLayer(s, n)) {
            return this.getLayer(s).getPanel(n);
        }
        return null;
    }

    public boolean isInLayer(String layer, GraphNode mem) {
        return ((GraphLayer)this.layers.get(layer)).contains(mem);
    }

    public GraphLayer getLayer(String name) {
        if (!this.layers.containsKey(name)) {
            return null;
        }
        return (GraphLayer)this.layers.get(name);
    }

    protected void addCBForLayer(String s) {
        JCheckBox cb = new JCheckBox(s, this.isVisible(s));
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox ch = (JCheckBox)e.getSource();
                GraphLayers.this.setVisible(ch.getText(), !GraphLayers.this.isVisible(ch.getText()));
            }
        });
        this.panel.add(cb);
    }

    protected void setDisplay(JTabbedPane p) {
        this.panel = p;
    }

    public synchronized void updateCfg() {
    }

    public synchronized void saveCfg() {
    }
}

