/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.io.Serializable;
import javax.swing.JPanel;
import utilities.EdgeNodePanel;
import utilities.GraphNode;

public class GraphEdge
extends GraphNode
implements Serializable,
Cloneable {
    protected GraphNode from = null;
    protected GraphNode to = null;
    protected boolean drawarrows = true;

    public GraphEdge(String l, GraphNode nodeFrom, GraphNode nodeTo) {
        super(l);
        this.setDrawArrows(true);
        this.setFrom(nodeFrom);
        this.setTo(nodeTo);
    }

    public GraphEdge(GraphNode nodeFrom, GraphNode nodeTo) {
        this(null, nodeFrom, nodeTo);
    }

    public GraphEdge(String l) {
        this(l, null, null);
    }

    public GraphEdge() {
        this(null, null, null);
    }

    public GraphNode getFrom() {
        return this.from;
    }

    public GraphNode getTo() {
        return this.to;
    }

    public void setFrom(GraphNode n) {
        if (this.from != null) {
            this.from.removeOutEdge(this);
            this.removeEdge(this.from);
        }
        this.from = n;
        if (this.from != null) {
            n.addOutEdge(this);
            this.addEdge(this.from);
        }
    }

    public void setDrawArrows(boolean b) {
        this.drawarrows = b;
    }

    public boolean getDrawArrows() {
        return this.drawarrows;
    }

    public void setTo(GraphNode n) {
        if (this.to != null) {
            this.to.removeInEdge(this);
            this.removeEdge(this.to);
        }
        this.to = n;
        if (this.to != null) {
            this.to.addInEdge(this);
            this.addEdge(this.to);
        }
    }

    protected void setEndpoints(GraphNode f, GraphNode t) {
        if (f instanceof GraphEdge || t instanceof GraphEdge) {
            System.err.println("Error: Cannot attach a graph edge to another graph edge");
            return;
        }
        this.setFrom(f);
        this.setTo(t);
    }

    public void excise() {
        super.excise();
        this.setEndpoints(null, null);
    }

    public boolean matches(Object o) {
        if (o == null) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            return super.equals(o);
        }
        return false;
    }

    public Object clone() {
        GraphEdge cloned = new GraphEdge(this.getLabel(), this.getTo(), this.getFrom());
        return cloned;
    }

    public JPanel getDefaultPanel() {
        return new EdgeNodePanel(this, this.getLabel());
    }
}

