/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import utilities.Distribution;
import utilities.Log;

public class Converter {
    public static Object reTypeProperty(String property, String type) {
        Cloneable newp = null;
        String delim = ",";
        if (property instanceof String) {
            StringTokenizer t;
            if (property.startsWith("DELIM=")) {
                StringTokenizer tmp = new StringTokenizer(property);
                delim = tmp.nextToken();
                property = property.substring(delim.length());
                property = property.trim();
                delim = delim.substring(6);
            }
            if (type == null || type.equalsIgnoreCase("String")) {
                newp = property;
            } else if (type.equalsIgnoreCase("Long")) {
                newp = Long.valueOf(property);
            } else if (type.equalsIgnoreCase("Integer")) {
                newp = Integer.valueOf(property);
            } else if (type.equalsIgnoreCase("Float")) {
                newp = Float.valueOf(property);
            } else if (type.equalsIgnoreCase("Double")) {
                newp = Double.valueOf(property);
            } else if (type.equalsIgnoreCase("Short")) {
                newp = Short.valueOf(property);
            } else if (type.equalsIgnoreCase("Boolean")) {
                newp = Boolean.valueOf(property);
            } else if (type.equalsIgnoreCase("Distribution")) {
                t = new StringTokenizer(property, delim);
                Distribution temp = new Distribution();
                while (t.hasMoreTokens()) {
                    try {
                        Float v = Float.valueOf(t.nextToken());
                        Float d = Float.valueOf(t.nextToken());
                        temp.appendTerm(v, d);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                        break;
                    }
                }
                newp = temp;
            } else if (type.equalsIgnoreCase("Vector")) {
                t = new StringTokenizer(property, delim);
                Vector<String> temp = new Vector<String>();
                while (t.hasMoreTokens()) {
                    temp.addElement(t.nextToken().trim());
                }
                newp = temp;
            } else if (type.equalsIgnoreCase("Hashtable")) {
                t = new StringTokenizer(property, delim);
                Hashtable<String, String> temp = new Hashtable<String, String>();
                while (t.hasMoreTokens()) {
                    String k = t.nextToken().trim();
                    String o = t.hasMoreTokens() ? t.nextToken().trim() : "Invalid hashtable specification";
                    temp.put(k, o);
                }
                newp = temp;
            } else {
                Log.getDefault().log("Error, unsupported conversion type " + type, 2);
            }
        }
        return newp;
    }

    public static String getPropertyType(Object property) {
        if (property == null) {
            return null;
        }
        String type = null;
        if (property instanceof String || property instanceof Long || property instanceof Integer || property instanceof Float || property instanceof Double || property instanceof Short || property instanceof Boolean || property instanceof Distribution || property instanceof Vector || property instanceof Hashtable) {
            type = property.getClass().getName();
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        return type;
    }

    public static String unTypeProperty(Object property, String delim) {
        String newp = null;
        if (delim == null) {
            delim = ",";
        }
        if (property == null) {
            return null;
        }
        if (property instanceof String || property instanceof Long || property instanceof Integer || property instanceof Float || property instanceof Double || property instanceof Short || property instanceof Boolean) {
            newp = property.toString();
        } else if (property instanceof Distribution) {
            newp = "";
            delim = " ";
            Enumeration e = ((Vector)property).elements();
            while (e.hasMoreElements()) {
                newp = newp + e.nextElement().toString();
                if (!e.hasMoreElements()) continue;
                newp = newp + delim;
            }
        } else if (property instanceof Vector) {
            newp = "DELIM=" + delim + " ";
            Enumeration e = ((Vector)property).elements();
            while (e.hasMoreElements()) {
                newp = newp + e.nextElement().toString();
                if (!e.hasMoreElements()) continue;
                newp = newp + delim;
            }
        } else if (property instanceof Hashtable) {
            newp = "DELIM=" + delim + " ";
            Enumeration e = ((Hashtable)property).keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                newp = newp + key.toString() + delim + ((Hashtable)property).get(key).toString();
                if (!e.hasMoreElements()) continue;
                newp = newp + delim;
            }
        } else {
            Log.getDefault().log("Error, unsupported conversion type " + property.getClass(), 2);
        }
        return newp;
    }
}

