/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import utilities.ContainerGraphNode;
import utilities.GraphLayout;
import utilities.GraphNode;
import utilities.NodePanel;

public class ContainerNodePanel
extends NodePanel {
    protected Dimension labelsize = null;
    HashMap linklocations = new HashMap();

    public ContainerNodePanel(ContainerGraphNode n, String l) {
        super(n, l);
        this.setLayout(new GraphLayout());
        this.setOpaque(false);
    }

    protected ContainerNodePanel() {
        this(null, new String(""));
    }

    public Dimension getLabelSize() {
        return this.labelsize;
    }

    public void repaint() {
        if (this.getParent() != null) {
            this.getParent().repaint();
        } else {
            super.repaint();
        }
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void paintComponent(Graphics g) {
        Rectangle rect = new Rectangle(this.getBounds());
        FontMetrics fm = g.getFontMetrics();
        g.setColor(Color.black);
        g.drawRect(0, 0, rect.width - 1, rect.height - 1);
        try {
            this.labelsize = new Dimension(fm.stringWidth(this.getLabel()) + H_MARGIN * 2, fm.getHeight());
            if (this.isSelected()) {
                g.setColor(Color.yellow);
            } else {
                g.setColor(Color.white);
            }
            g.fillRoundRect(H_MARGIN, rect.height - this.labelsize.height, this.labelsize.width, this.labelsize.height - V_MARGIN, 5, 5);
            g.setColor(this.getForeground());
            g.drawRoundRect(H_MARGIN, rect.height - this.labelsize.height, this.labelsize.width, this.labelsize.height - V_MARGIN, 5, 5);
            g.drawString(this.getLabel(), H_MARGIN * 2, rect.height - V_MARGIN * 2);
        }
        catch (NullPointerException ex) {
            System.err.println("Error drawing label");
            ex.printStackTrace();
        }
    }

    public Point getLinkLocation(String name) {
        return (Point)this.linklocations.get(name);
    }

    public void setLinkLocation(String name, Point loc) {
        this.linklocations.put(name, loc);
    }

    public Point getLocationForLine() {
        Dimension d = this.getLabelSize();
        if (d == null) {
            d = this.getSize();
        }
        int x = this.getX() + d.width / 2;
        int y = this.getY() + this.getHeight() - d.height / 2;
        return new Point(x, y);
    }

    public Point getLocationForLine(GraphNode n) {
        Point tmp = (Point)this.linklocations.get(n);
        if (tmp != null) {
            return tmp;
        }
        return this.getLocationForLine();
    }

    public boolean intersects(Rectangle r) {
        Rectangle r2 = this.getBounds();
        if (r2 != null) {
            return r.intersects(r2);
        }
        return false;
    }

    public Dimension getPreferredSize() {
        if (this.getShape() != null || this.getBackImage() != null) {
            return super.getPreferredSize();
        }
        Dimension d = this.getLayout().preferredLayoutSize(this.getParent());
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int height = d.height + fm.getHeight() + V_MARGIN * 2;
        int width = Math.max(d.width, fm.stringWidth(this.getLabel()) + H_MARGIN * 4);
        return new Dimension(width, height);
    }
}

