/*
 * Decompiled with CFR 0.152.
 */
package taems.preprocessor;

import java.util.Hashtable;
import taems.preprocessor.Block;
import taems.preprocessor.DefineBlock;
import taems.preprocessor.PreProcessor;

public class Variable
extends Block {
    protected String key;
    protected Object cache;
    protected boolean local = false;

    public Variable(PreProcessor p, String k) {
        super(p);
        this.key = k;
    }

    public String toPTaems() {
        String answer = "$" + this.key;
        return answer;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isDefined(Hashtable ht) {
        if (ht.containsKey(this.key)) {
            return true;
        }
        return this.preprocessor.getVarReference(this.key) != null;
    }

    public String toTTaems(Hashtable ht) {
        String answer = "";
        if (this.local) {
            return (String)this.cache;
        }
        if (ht.containsKey(this.key)) {
            answer = ht.get(this.key).toString();
        } else if (this.preprocessor.getVarReference(this.key) != null) {
            answer = (String)((DefineBlock)this.preprocessor.getVarReference(this.key)).evaluate(ht);
        } else {
            this.log.log("No matching for $" + this.key, 2);
            answer = "$" + this.key;
        }
        this.log.log("Variable.toTTaems(" + this.key + ") = [" + answer + "]", 4);
        return answer;
    }

    public Object evaluate(Hashtable ht) {
        return this.toTTaems(ht);
    }

    public void dereference(Hashtable ht, String k) {
        if (k.equals(this.key)) {
            this.cache = this.evaluate(ht);
            this.local = true;
        }
    }

    public void reset() {
        this.local = false;
        this.cache = null;
    }
}

