/*
 * Decompiled with CFR 0.152.
 */
package taems.preprocessor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.preprocessor.Block;
import taems.preprocessor.ListBlock;
import utilities.Log;

public class PreProcessor {
    protected Hashtable varreference;
    protected Hashtable listreference;
    protected Log log = Log.getDefault();
    protected Vector blocks;

    public PreProcessor() {
        this.varreference = new Hashtable();
        this.listreference = new Hashtable();
        this.blocks = new Vector();
    }

    public void addReference(String name, Block b) {
        this.addVarReference(name, b);
    }

    public Block getReference(String name) {
        return this.getVarReference(name);
    }

    public void addVarReference(String name, Block b) {
        this.varreference.put(name, b);
    }

    public Block getVarReference(String name) {
        return (Block)this.varreference.get(name);
    }

    public void addListReference(String name, ListBlock b) {
        this.listreference.put(name, b);
    }

    public ListBlock getListReference(String name) {
        return (ListBlock)this.listreference.get(name);
    }

    public void addBlock(Block b) {
        this.blocks.addElement(b);
    }

    public void addBlocks(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.addBlock((Block)e.nextElement());
        }
    }

    public String toTTaems(Hashtable ht) {
        String answer = "";
        Enumeration e = this.getBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            answer = answer + "\n" + b.toTTaems(ht);
        }
        return answer;
    }

    public void reset() {
        Enumeration e = this.getBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            b.reset();
        }
        this.varreference.clear();
        this.listreference.clear();
    }

    public Enumeration getBlocks() {
        return this.blocks.elements();
    }

    public int getNumberOfBlock() {
        return this.blocks.size();
    }

    public String toString() {
        return this.toPTaems();
    }

    public String toPTaems() {
        String answer = "";
        Enumeration e = this.getBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            answer = answer + "\n" + b.toPTaems();
        }
        return answer;
    }
}

