/*
 * Decompiled with CFR 0.152.
 */
package taems.preprocessor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.preprocessor.PreProcessor;
import utilities.Log;

public class Block {
    protected Vector subBlock;
    protected PreProcessor preprocessor;
    protected Log log = Log.getDefault();

    public Block() {
    }

    public Block(PreProcessor p) {
        this.subBlock = new Vector();
        this.preprocessor = p;
    }

    public String toString() {
        return this.toPTaems();
    }

    public String toPTaems() {
        String answer = "";
        Enumeration e = this.getSubBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            answer = answer + b.toPTaems();
        }
        return answer;
    }

    public Enumeration getSubBlocks() {
        return this.subBlock.elements();
    }

    public int getNumberOfSubBlock() {
        return this.subBlock.size();
    }

    public Block getSubBlockAt(int position) {
        return (Block)this.subBlock.elementAt(position);
    }

    public void addSubBlock(Block b) {
        this.subBlock.addElement(b);
    }

    public void addSubBlocks(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.addSubBlock((Block)e.nextElement());
        }
    }

    public void addString(String b) {
        this.subBlock.addElement(b);
    }

    public String toTTaems(Hashtable ht) {
        String answer = "";
        Enumeration e = this.getSubBlocks();
        while (e.hasMoreElements()) {
            Block b = (Block)e.nextElement();
            answer = answer + b.toTTaems(ht);
        }
        return answer;
    }

    public void reset() {
        if (this.subBlock != null) {
            Enumeration e = this.getSubBlocks();
            while (e.hasMoreElements()) {
                Block b = (Block)e.nextElement();
                b.reset();
            }
        }
    }

    public Object evaluate(Hashtable ht) {
        return this.toTTaems(ht);
    }

    public void dereference(Hashtable ht, String key) {
        if (this.subBlock != null) {
            Enumeration e = this.getSubBlocks();
            while (e.hasMoreElements()) {
                Block b = (Block)e.nextElement();
                b.dereference(ht, key);
            }
        }
    }
}

