/*
 * Decompiled with CFR 0.152.
 */
package taems.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import taems.Taems;
import taems.parser.TTaemsGrammar;
import utilities.Log;

public class ReadTTaems {
    private static TTaemsGrammar parser = null;
    private static Integer lock = new Integer(1);
    private Log log;

    public ReadTTaems(Log l) {
        this.log = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taems readTTaems(InputStream stream) {
        if (stream == null) {
            return null;
        }
        Integer n = lock;
        synchronized (n) {
            try {
                if (parser == null) {
                    parser = new TTaemsGrammar(stream);
                } else {
                    TTaemsGrammar.ReInit(stream);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e);
            }
            return this.runParser(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taems readTTaems(String filename) {
        Taems task;
        FileInputStream fis = null;
        this.log.log("Reading textual taems file " + filename);
        try {
            fis = new FileInputStream(filename);
        }
        catch (Exception e) {
            this.log.log("Error finding textual taems input file " + filename);
        }
        this.log.log("File found and opened");
        Integer e = lock;
        synchronized (e) {
            if (fis == null) {
                return null;
            }
            try {
                if (parser == null) {
                    parser = new TTaemsGrammar(fis);
                } else {
                    TTaemsGrammar.ReInit(fis);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.err.println(e2);
            }
            task = this.runParser(parser);
        }
        try {
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println(ioe);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taems readTTaems(Reader r) {
        if (r == null) {
            return null;
        }
        Integer n = lock;
        synchronized (n) {
            try {
                if (parser == null) {
                    parser = new TTaemsGrammar(r);
                } else {
                    TTaemsGrammar.ReInit(r);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(e);
            }
            return this.runParser(parser);
        }
    }

    private Taems runParser(TTaemsGrammar p) {
        Taems task_structure = null;
        Log log = Log.getDefault();
        try {
            log.log("Parser opened");
            if (parser == null) {
                log.log("Parser opening failed");
                return null;
            }
            task_structure = TTaemsGrammar.Input(log);
            log.log("parsed successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
        }
        return task_structure;
    }
}

