/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import taems.Agent;
import taems.Node;
import taems.NodeUpdateEvent;
import taems.Task;
import taems.VirtualTaskBase;
import utilities.EnumerationEnumeration;

public class TaskBase
extends Node
implements Serializable,
Cloneable {
    protected int arrival_time = Integer.MIN_VALUE;
    protected int earliest_start_time = Integer.MIN_VALUE;
    protected int deadline = Integer.MIN_VALUE;
    protected Boolean nonlocal = null;
    protected Vector supertasks = new Vector();

    public TaskBase(String l, Agent a, int at, int est, int dl) {
        super(l, a);
        this.arrival_time = at;
        this.earliest_start_time = est;
        this.deadline = dl;
        this.setCurrentQuality(0.0f);
        this.setCurrentDuration(0.0f);
        this.setCurrentCost(0.0f);
    }

    public TaskBase(String l, Agent a) {
        this(l, a, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public TaskBase() {
        this(null, null);
    }

    public int getArrivalTime() {
        return this.arrival_time;
    }

    public void setArrivalTime(int a) {
        if (this.getArrivalTime() == a) {
            return;
        }
        this.arrival_time = a;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public int getEarliestStartTime() {
        return this.earliest_start_time;
    }

    public void setEarliestStartTime(int e) {
        if (this.getEarliestStartTime() == e) {
            return;
        }
        this.earliest_start_time = e;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public int getComposedDeadline() {
        int dl = this.getDeadline();
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            int dl1 = n.getComposedDeadline();
            if (dl1 == Integer.MIN_VALUE) continue;
            if (this.deadline != Integer.MIN_VALUE) {
                dl = Math.min(dl, dl1);
                continue;
            }
            dl = dl1;
        }
        return dl;
    }

    public int getComposedEarliestStartTime() {
        int estime = this.getEarliestStartTime();
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            estime = Math.max(estime, n.getComposedEarliestStartTime());
        }
        return estime;
    }

    public int getDeadline() {
        return this.deadline;
    }

    public void setDeadline(int d) {
        if (this.getDeadline() == d) {
            return;
        }
        this.deadline = d;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public void unsetDeadline() {
        this.setDeadline(Integer.MIN_VALUE);
    }

    public boolean getNonLocal() {
        if (this.nonlocal == null) {
            return false;
        }
        return this.nonlocal;
    }

    public boolean isNonLocal() {
        return this.getNonLocal();
    }

    public void setNonLocal(boolean n) {
        if (this.nonlocal != null && this.nonlocal == n) {
            return;
        }
        this.nonlocal = new Boolean(n);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public int getStartTime() {
        return Integer.MIN_VALUE;
    }

    public void setStartTime(int s) {
        this.updateParentQualities();
    }

    public int getFinishTime() {
        return Integer.MIN_VALUE;
    }

    public void setFinishTime(int f) {
        this.updateParentQualities();
    }

    public boolean hasFinished() {
        return this.getFinishTime() >= 0;
    }

    public boolean hasStarted() {
        return this.getStartTime() >= 0;
    }

    public float getCurrentQuality() {
        if (this.hasAttribute("cur_quality")) {
            return ((Float)this.getAttribute("cur_quality")).floatValue();
        }
        return 0.0f;
    }

    public void setCurrentQuality(float q) {
        if (this.getCurrentQuality() == q) {
            return;
        }
        this.setAttribute("cur_quality", new Float(q));
        this.updateParentQualities();
    }

    public void updateParentQualities() {
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            Node t = (Node)e.nextElement();
            if (!(t instanceof Task)) continue;
            ((Task)t).updateQuality();
        }
    }

    public float getMaximumQuality() {
        if (this.hasAttribute("max_quality")) {
            return ((Float)this.getAttribute("max_quality")).floatValue();
        }
        return 0.0f;
    }

    public void setMaximumQuality(float q) {
        this.setAttribute("max_quality", new Float(q));
    }

    public float getCurrentDuration() {
        if (this.hasAttribute("cur_duration")) {
            return ((Float)this.getAttribute("cur_duration")).floatValue();
        }
        return 0.0f;
    }

    public void setCurrentDuration(float d) {
        if (this.getCurrentDuration() == d) {
            return;
        }
        this.setAttribute("cur_duration", new Float(d));
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            Node t = (Node)e.nextElement();
            if (!(t instanceof Task)) continue;
            ((Task)t).updateDuration();
        }
    }

    public float getCurrentCost() {
        if (this.hasAttribute("cur_cost")) {
            return ((Float)this.getAttribute("cur_cost")).floatValue();
        }
        return 0.0f;
    }

    public void setCurrentCost(float c) {
        if (this.getCurrentCost() == c) {
            return;
        }
        this.setAttribute("cur_cost", new Float(c));
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            Node t = (Node)e.nextElement();
            if (!(t instanceof Task)) continue;
            ((Task)t).updateCost();
        }
    }

    public Enumeration getAffectingInterrelationships() {
        Vector<Enumeration> v = new Vector<Enumeration>();
        v.addElement(this.getInInterrelationships());
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            v.addElement(n.getAffectingInterrelationships());
        }
        return new EnumerationEnumeration(v);
    }

    public Enumeration getAffectedInterrelationships() {
        Vector<Enumeration> v = new Vector<Enumeration>();
        v.addElement(this.getOutInterrelationships());
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            v.addElement(n.getAffectedInterrelationships());
        }
        return new EnumerationEnumeration(v);
    }

    public Node excise() {
        Node n = super.excise();
        VirtualTaskBase vn = new VirtualTaskBase(n.getLabel(), n.getAgent());
        n.transferInterrelationships(vn);
        while (this.hasSupertasks()) {
            Task t = (Task)this.supertasks.firstElement();
            t.replaceSubtask(this, vn);
        }
        return vn;
    }

    public void delete() {
        while (this.hasSupertasks()) {
            Task t = (Task)this.supertasks.firstElement();
            t.removeSubtask(this);
        }
        super.delete();
    }

    protected void addSupertask(Task st) {
        this.supertasks.addElement(st);
    }

    protected void removeSupertask(Task st) {
        this.supertasks.removeElement(st);
    }

    protected void transferSupertasks(TaskBase n) {
        if (this == n) {
            return;
        }
        while (this.hasSupertasks()) {
            Task t = this.firstSupertask();
            t.replaceSubtask(this, n);
        }
    }

    public Enumeration getSupertasks() {
        return this.supertasks.elements();
    }

    public Task firstSupertask() {
        try {
            return (Task)this.supertasks.firstElement();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public Task firstVisibleSupertask() {
        try {
            Enumeration e = this.getSupertasks();
            while (e.hasMoreElements()) {
                Task t = (Task)e.nextElement();
                if (!t.isVisible() || t.isCollapsed()) continue;
                return t;
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return null;
    }

    public int numSupertasks() {
        return this.supertasks.size();
    }

    public boolean hasSupertasks() {
        return this.numSupertasks() > 0;
    }

    public void removeAllSupertasks() {
        while (this.hasSupertasks()) {
            Task t = (Task)this.supertasks.firstElement();
            t.removeSubtask(this);
        }
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
    }

    public int calculateTreeDepth() {
        int d = 1;
        if (this.hasSupertasks()) {
            Enumeration e = this.getSupertasks();
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                d = Math.max(d, 1 + t.calculateTreeDepth());
            }
        }
        return d;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        sb.append(super.toTTaems(v));
        if (this.arrival_time != Integer.MIN_VALUE) {
            sb.append("   (arrival_time " + this.arrival_time + ")\n");
        }
        if (this.earliest_start_time != Integer.MIN_VALUE) {
            sb.append("   (earliest_start_time " + this.earliest_start_time + ")\n");
        }
        if (this.deadline != Integer.MIN_VALUE) {
            sb.append("   (deadline " + this.deadline + ")\n");
        }
        if (this.isNonLocal()) {
            if (v >= 1.1f) {
                sb.append("   (nonlocal)\n");
            } else {
                sb.append("   (method_is_non_local)\n");
            }
        }
        if (this.hasSupertasks()) {
            sb.append("   (supertasks ");
            Enumeration e = this.getSupertasks();
            while (e.hasMoreElements()) {
                sb.append(((Node)e.nextElement()).getLabel());
                if (!e.hasMoreElements()) continue;
                sb.append(" ");
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public boolean matches(Node n) {
        if (n.getClass().isInstance(this)) {
            if (!super.matches(n)) {
                return false;
            }
        } else {
            return false;
        }
        if (n instanceof TaskBase) {
            if (!TaskBase.matches(((TaskBase)n).getArrivalTime(), this.getArrivalTime())) {
                return false;
            }
            if (!TaskBase.matches(((TaskBase)n).getEarliestStartTime(), this.getEarliestStartTime())) {
                return false;
            }
            if (!TaskBase.matches(((TaskBase)n).getDeadline(), this.getDeadline())) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        TaskBase cloned = null;
        try {
            cloned = (TaskBase)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.setArrivalTime(this.getArrivalTime());
        cloned.setEarliestStartTime(this.getEarliestStartTime());
        cloned.setDeadline(this.getDeadline());
        cloned.setNonLocal(this.getNonLocal());
        cloned.supertasks = new Vector();
        return cloned;
    }

    public void copy(Node n) {
        if (n instanceof TaskBase) {
            TaskBase t = (TaskBase)n;
            t.setArrivalTime(this.getArrivalTime());
            t.setEarliestStartTime(this.getEarliestStartTime());
            t.setDeadline(this.getDeadline());
            t.setNonLocal(this.getNonLocal());
        }
        super.copy(n);
    }

    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        if (!this.hasSupertasks()) {
            return true;
        }
        boolean c = true;
        Enumeration e = this.getSupertasks();
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            if (t.isCollapsed()) continue;
            c = false;
            break;
        }
        if (c) {
            return false;
        }
        boolean i = true;
        Enumeration e2 = this.getSupertasks();
        while (e2.hasMoreElements()) {
            TaskBase t = (TaskBase)e2.nextElement();
            if (!t.isVisible()) continue;
            i = false;
            break;
        }
        return !i;
    }

    protected Color getBackground() {
        if (this.isSelected()) {
            return super.getBackground();
        }
        switch (this.getStatus()) {
            case 0: {
                if (!this.isNonLocal()) break;
                return Color.lightGray;
            }
        }
        return super.getBackground();
    }

    protected Color getForeground() {
        if (this.isNonLocal()) {
            return Color.darkGray;
        }
        return super.getForeground();
    }
}

