/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import taems.Agent;
import taems.Interrelationship;
import taems.Node;
import taems.NodeUpdateEvent;
import taems.QAF;
import taems.Taems;
import taems.TaskBase;
import taems.VirtualTaskBase;
import utilities.EnumerationEnumeration;
import utilities.SafeEnumeration;

public class Task
extends TaskBase
implements Serializable,
Cloneable {
    protected QAF qaf = null;
    protected Vector subtasks = new Vector();
    protected static final int H_SPACE = 50;
    protected static final int V_SPACE = 50;

    public Task(String l, Agent a, QAF q, int at, int est, int dl) {
        super(l, a, at, est, dl);
        this.qaf = q;
    }

    public Task(String l, Agent a, QAF q) {
        this(l, a, q, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public Task() {
        this(null, null, null, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public QAF getQAF() {
        return this.qaf;
    }

    public void setQAF(QAF q) {
        if (this.getQAF() != null && this.getQAF().matches(q)) {
            return;
        }
        this.qaf = q;
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public int getStartTime() {
        int s = Integer.MAX_VALUE;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            int ns = n.getStartTime();
            if (ns == Integer.MIN_VALUE || ns >= s) continue;
            s = ns;
        }
        if (s == Integer.MAX_VALUE) {
            s = Integer.MIN_VALUE;
        }
        return s;
    }

    public int getFinishTime() {
        int s = Integer.MIN_VALUE;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            int ns = n.getFinishTime();
            if (ns <= s) continue;
            s = ns;
        }
        return s;
    }

    public float getMaximumQuality() {
        if (this.hasAttribute("max_quality")) {
            return ((Float)this.getAttribute("max_quality")).floatValue();
        }
        Enumeration e = this.getSubtasks();
        float maximumQuality = this.getQAF().calculateMaximumQuality(e);
        this.setMaximumQuality(maximumQuality);
        return maximumQuality;
    }

    public void updateQuality() {
        float q = 0.0f;
        if (this.getQAF() != null) {
            Enumeration e = this.getSubtasks();
            q = this.getQAF().calculateQuality(e);
        }
        this.setCurrentQuality(q);
    }

    public void updateDuration() {
        float d = 0.0f;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            d += t.getCurrentDuration();
        }
        this.setCurrentDuration(d);
    }

    public void updateCost() {
        float c = 0.0f;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            c += t.getCurrentCost();
        }
        this.setCurrentCost(c);
    }

    public void updateState() {
        this.updateQuality();
        this.updateDuration();
        this.updateCost();
    }

    public Node excise() {
        Node n = super.excise();
        SafeEnumeration e = new SafeEnumeration(this.getSubtasks());
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            this.replaceSubtask(t, new VirtualTaskBase(t.getLabel(), t.getAgent()));
        }
        return n;
    }

    public void delete() {
        SafeEnumeration e = new SafeEnumeration(this.getSubtasks());
        while (this.hasSubtasks()) {
            TaskBase t = (TaskBase)this.subtasks.firstElement();
            this.removeSubtask(t);
            if (t.hasSupertasks()) continue;
            t.delete();
        }
        super.delete();
    }

    public void addSubtask(TaskBase st) {
        this.subtasks.addElement(st);
        st.addSupertask(this);
        st.addNodeUpdateEventListener(this);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
        this.updateState();
    }

    public void insertSubtask(TaskBase st, int i) {
        this.subtasks.insertElementAt(st, i);
        st.addSupertask(this);
        st.addNodeUpdateEventListener(this);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
        this.updateState();
    }

    public void setSubtask(TaskBase st, int i) {
        TaskBase ost = this.getSubtask(i);
        if (ost != null) {
            ost.removeSupertask(this);
            ost.removeNodeUpdateEventListener(this);
        }
        this.subtasks.setElementAt(st, i);
        st.addSupertask(this);
        st.addNodeUpdateEventListener(this);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
        this.updateState();
    }

    public void replaceSubtask(TaskBase ot, TaskBase nt) {
        int index = this.getSubtaskPosition(ot);
        if (index > -1) {
            this.setSubtask(nt, index);
        }
    }

    public void removeSubtask(TaskBase st) {
        st.removeSupertask(this);
        this.subtasks.removeElement(st);
        st.removeNodeUpdateEventListener(this);
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 2));
        this.updateState();
    }

    public TaskBase getSubtask(int i) {
        try {
            return (TaskBase)this.subtasks.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getSubtaskPosition(Node n) {
        return this.subtasks.indexOf(n);
    }

    public Enumeration getSubtasks() {
        return this.subtasks.elements();
    }

    public Enumeration getAllSubtasks() {
        Vector<Enumeration> v = new Vector<Enumeration>();
        v.addElement(this.subtasks.elements());
        Enumeration e = this.subtasks.elements();
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            if (!(t instanceof Task)) continue;
            v.addElement(((Task)t).getAllSubtasks());
        }
        return new EnumerationEnumeration(v, true);
    }

    public int numSubtasks() {
        return this.subtasks.size();
    }

    public boolean isTaskGroup() {
        return !this.hasSupertasks();
    }

    public boolean hasSubtasks() {
        return this.subtasks.size() > 0;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        if (v == 1.0f && !this.hasSubtasks()) {
            return "";
        }
        if (this.isTaskGroup()) {
            sb.append("(spec_task_group\n");
        } else {
            sb.append("(spec_task\n");
        }
        sb.append(super.toTTaems(v));
        if (this.hasSubtasks()) {
            StringBuffer comment = new StringBuffer("");
            sb.append("   (subtasks ");
            Enumeration e = this.getSubtasks();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                if (v == 1.0f && ((TaskBase)n).isNonLocal() || v == 1.0f && n instanceof Task && !((Task)n).hasSubtasks()) continue;
                sb.append(n.getLabel());
                if (n.isVirtual()) {
                    comment.append(";  ** Note: node " + n.getLabel() + " is virtual\n");
                }
                if (!e.hasMoreElements()) continue;
                sb.append(" ");
            }
            sb.append(")\n");
            sb.append(comment.toString());
        }
        if (this.getQAF() != null) {
            sb.append("   (qaf " + this.getQAF().getLabel() + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }

    public boolean matches(Node n) {
        if (n.getClass().isInstance(this)) {
            if (!super.matches(n)) {
                return false;
            }
        } else {
            return false;
        }
        if (n instanceof Task) {
            if (((Task)n).getQAF() != null) {
                if (this.getQAF() == null) {
                    return false;
                }
                if (!this.getQAF().getClass().isInstance(((Task)n).getQAF())) {
                    return false;
                }
            }
            if (((Task)n).hasSubtasks()) {
                if (((Task)n).numSubtasks() != this.numSubtasks()) {
                    return false;
                }
                Enumeration e1 = this.getSubtasks();
                Enumeration e2 = ((Task)n).getSubtasks();
                while (e1.hasMoreElements()) {
                    TaskBase tb2;
                    TaskBase tb1 = (TaskBase)e1.nextElement();
                    if (tb1.matches(tb2 = (TaskBase)e2.nextElement())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Object clone() {
        Enumeration e;
        Task cloned = null;
        try {
            cloned = (Task)super.clone();
        }
        catch (Exception e2) {
            System.out.println("Clone Error: " + e2);
        }
        if (this.qaf != null) {
            cloned.setQAF((QAF)this.qaf.clone());
        } else {
            cloned.setQAF(this.qaf);
        }
        cloned.subtasks = new Vector();
        if (this.hasSubtasks()) {
            e = this.getSubtasks();
            while (e.hasMoreElements()) {
                TaskBase t = (TaskBase)e.nextElement();
                if (t.firstSupertask() == this) {
                    cloned.addSubtask((TaskBase)t.clone());
                    continue;
                }
                cloned.addSubtask(new VirtualTaskBase(t.getLabel(), t.getAgent()));
            }
        }
        e = cloned.findNodes(new Interrelationship(null, null, null, null, null, null));
        while (e.hasMoreElements()) {
            Node temp;
            Interrelationship i = (Interrelationship)e.nextElement();
            if (!i.getTo().isVirtual()) continue;
            Enumeration ne = cloned.findNodes(new Node(i.getTo().getLabel(), i.getTo().getAgent()));
            if (ne.hasMoreElements()) {
                temp = (Node)ne.nextElement();
                if (temp.isVirtual()) continue;
                i.setTo(temp);
            }
            if (!ne.hasMoreElements() || (temp = (Node)ne.nextElement()).isVirtual()) continue;
            System.err.println("Warning: Duplicate match(es) found for IR (" + i.getLabel() + ") target " + temp.getLabel());
        }
        return cloned;
    }

    public void copy(Node n) {
        if (n instanceof Task) {
            Task t = (Task)n;
            if (this.qaf != null) {
                t.setQAF((QAF)this.qaf.clone());
            } else {
                t.setQAF(this.qaf);
            }
        }
        super.copy(n);
    }

    public void setSubLocations(FontMetrics fm) {
        int curx = this.getLocation().x - this.calculateSubTreeWidth(fm) / 2;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            if (n.firstSupertask() != this) continue;
            int width = n.calculateTreeWidth(fm);
            n.setLocation(new Point(curx + width / 2, this.getLocation().y + 50));
            if (n instanceof Task) {
                ((Task)n).setSubLocations(fm);
            }
            curx += width + 50;
        }
    }

    public void paintLines(Graphics g) {
        if (this.isVisible() && !this.isCollapsed()) {
            Enumeration e = this.getSubtasks();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                if (this.isSelected()) {
                    g.setColor(Color.red);
                } else if (n.isSelected()) {
                    g.setColor(Color.blue);
                } else {
                    g.setColor(Color.black);
                }
                if (this.getLocation() == null) {
                    System.err.println("getLocation() return null for task " + this.getLabel());
                } else if (n.getLocation() == null) {
                    System.err.println("getLocation() return null for task child " + n.getLabel());
                } else {
                    g.drawLine(this.getLocation().x, this.getLocation().y, n.getLocation().x, n.getLocation().y);
                }
                n.paintLines(g);
            }
        }
        super.paintLines(g);
    }

    public void paint(Graphics g) {
        Node n;
        Enumeration e;
        g.setFont(normalFont);
        this.updateBounds(g.getFontMetrics());
        if (this.isVisible()) {
            g.setColor(this.getBackground());
            g.fillRoundRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.rect.height, this.rect.height);
            g.setColor(Color.black);
            if (this.isCollapsed()) {
                ((Graphics2D)g).setStroke(collapsedstroke);
            }
            g.drawRoundRect(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.rect.height, this.rect.height);
            if (this.isCollapsed()) {
                ((Graphics2D)g).setStroke(normalstroke);
            }
            try {
                g.setColor(this.getForeground());
                g.drawString(this.getLabel(), this.rect.x + 5, this.rect.y + this.rect.height - (2 + g.getFontMetrics().getDescent()));
                g.setFont(smallFont);
                FontMetrics fm = g.getFontMetrics();
                if (this.getQAF() != null) {
                    if (Taems.printing) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.gray);
                    }
                    g.drawString(this.getQAF().getLabel(), this.getLocation().x - fm.stringWidth(this.qaf.getLabel()) / 2, this.rect.y + this.rect.height + 2 + fm.getAscent());
                }
                if (this.getCurrentQuality() != 0.0f) {
                    String num = String.valueOf(this.getCurrentQuality());
                    g.setColor(Color.red);
                    g.drawString(num, this.rect.x - (fm.stringWidth(num) + 5), this.rect.y + this.rect.height - (2 + fm.getDescent()));
                }
            }
            catch (NullPointerException ex) {
                System.err.println("Error drawing label");
                ex.printStackTrace();
            }
            g.setFont(normalFont);
        }
        if (!this.isCollapsed()) {
            e = this.getSubtasks();
            while (e.hasMoreElements()) {
                n = (TaskBase)e.nextElement();
                if (((TaskBase)n).firstVisibleSupertask() != this) continue;
                n.paint(g);
            }
        }
        e = this.getOutInterrelationships();
        while (e.hasMoreElements()) {
            n = (Node)e.nextElement();
            n.paint(g);
        }
    }

    public int calculateTreeWidth(FontMetrics fm) {
        int width = super.calculateTreeWidth(fm);
        int subwidth = this.calculateSubTreeWidth(fm);
        return Math.max(width, subwidth);
    }

    public int calculateSubTreeWidth(FontMetrics fm) {
        int width = -50;
        Enumeration e = this.getSubtasks();
        while (e.hasMoreElements()) {
            TaskBase n = (TaskBase)e.nextElement();
            if (n.firstSupertask() != this) continue;
            width += n.calculateTreeWidth(fm) + 50;
        }
        return width;
    }

    public int calculateTreeHeight(FontMetrics fm) {
        int height = super.calculateTreeHeight(fm);
        int sheight = 0;
        if (this.hasSubtasks()) {
            height += 50;
            Enumeration e = this.getSubtasks();
            while (e.hasMoreElements()) {
                TaskBase n = (TaskBase)e.nextElement();
                if (n.firstSupertask() != this) continue;
                sheight = Math.max(sheight, n.calculateTreeHeight(fm) - n.calculateHeight(fm) / 2);
            }
        }
        return height + sheight;
    }
}

