/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import taems.Taems;
import taems.parser.ReadTTaems;
import utilities.Log;

public class SimpleDisplay {
    private static Log genlog = Log.getDefault();
    private static ReadTTaems reader = new ReadTTaems(genlog);
    private static final int INITIAL_WIDTH = 500;
    private static final int INITIAL_HEIGHT = 400;

    public static void main(String[] argv) {
        int i;
        Taems task = new Taems("Combined Output");
        Object file_name = null;
        boolean silent = false;
        for (i = 0; i < argv.length; ++i) {
            if (!argv[i].startsWith("-")) continue;
            if (argv[i].equals("-silent")) {
                genlog.setLevel(-1);
            }
            if (!argv[i].equals("-s")) continue;
            genlog.setLevel(-1);
        }
        SimpleDisplay.showTaems(task);
        for (i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-")) continue;
            String input_script = argv[i];
            genlog.log("Reading textual taems file " + input_script);
            Taems temp = reader.readTTaems(input_script);
            genlog.log("Textual taems file read!");
            genlog.log("Combining " + temp.getLabel());
            task.addTaems(temp);
        }
    }

    public static void showTaems(Taems t) {
        JFrame frame = new JFrame("Taems");
        frame.setSize(500, 400);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 250, screenSize.height / 2 - 200);
        frame.getContentPane().add((Component)t, "Center");
        frame.setVisible(true);
    }
}

