/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import taems.QAF;
import taems.TaskBase;

public class SeqSumQAF
extends QAF
implements Serializable,
Cloneable {
    public SeqSumQAF() {
        super("q_seq_sum");
    }

    public float calculateQuality(Enumeration e) {
        float q = 0.0f;
        int lf = Integer.MIN_VALUE;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            if (!t.hasFinished()) {
                q = 0.0f;
                break;
            }
            if (lf > t.getStartTime()) {
                q = 0.0f;
                break;
            }
            lf = t.getFinishTime();
            float weight = 1.0f;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            float cq = weight * t.getCurrentQuality();
            q += cq;
        }
        return q;
    }

    public float calculateMaximumQuality(Enumeration e) {
        float q = 0.0f;
        while (e.hasMoreElements()) {
            TaskBase t = (TaskBase)e.nextElement();
            float weight = 1.0f;
            if (t.getAttribute("weighting_factor") != null) {
                weight = ((Float)t.getAttribute("weighting_factor")).floatValue();
            }
            q += weight * t.getMaximumQuality();
        }
        return q;
    }
}

