/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import taems.MLCSchedule;
import taems.Method;
import taems.Node;
import taems.Precondition;
import taems.Schedule;
import taems.ScheduleElementDisplay;
import taems.VirtualMethod;
import taems.VirtualScheduleElement;
import utilities.Distribution;
import utilities.Log;

public class ScheduleElement
implements Serializable,
Cloneable,
Comparable {
    static int currentID = 0;
    protected int ID;
    protected Method method = null;
    protected Distribution start_time = null;
    protected Distribution finish_time = null;
    protected Distribution quality = null;
    protected Distribution duration = null;
    protected Distribution cost = null;
    protected Vector quality_monitoring_info = null;
    protected Vector duration_monitoring_info = null;
    protected Schedule schedule = null;
    private ScheduleElementDisplay display = null;
    protected int actual_start = Integer.MIN_VALUE;
    protected int actual_finish = Integer.MIN_VALUE;
    protected Vector preconditions = new Vector();
    protected Vector dependingof = new Vector();
    protected Vector dependanceto = new Vector();
    protected boolean bindings = false;
    protected Hashtable attributes = new Hashtable();
    protected transient Log log = Log.getDefault();
    protected static Vector propagationList = new Vector();
    protected boolean updated = false;

    public ScheduleElement(Method m, Distribution st, Distribution ft, Distribution qd, Distribution dd, Distribution cd, Vector qm, Vector dm) {
        this.setID(currentID++);
        this.method = m;
        this.start_time = st;
        this.finish_time = ft;
        this.quality = qd;
        this.duration = dd;
        this.cost = cd;
        this.quality_monitoring_info = qm;
        this.duration_monitoring_info = dm;
        this.display = new ScheduleElementDisplay(this);
    }

    public ScheduleElement() {
        this.setID(currentID++);
    }

    public ScheduleElement(int id) {
        this.setID(id);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ScheduleElementDisplay temp = this.display;
        Log templog = this.log;
        this.display = null;
        this.log = null;
        out.defaultWriteObject();
        this.display = temp;
        this.log = templog;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.display = new ScheduleElementDisplay(this);
        ScheduleElement scheduleElement = this;
        this.log = scheduleElement.log.getDefault();
    }

    public Method getMethod() {
        return this.method;
    }

    public String getLabel() {
        if (this.getMethod() == null) {
            return null;
        }
        return this.getMethod().getLabel();
    }

    protected void setID(int i) {
        this.ID = i;
    }

    public int getID() {
        return this.ID;
    }

    public Distribution getStartTime() {
        return this.start_time;
    }

    public Distribution getFinishTime() {
        return this.finish_time;
    }

    public Distribution getQualityDistribution() {
        return this.quality;
    }

    public Distribution getDurationDistribution() {
        return this.duration;
    }

    public Distribution getCostDistribution() {
        return this.cost;
    }

    public int getEarliestStartTime() {
        return this.getMethod().getActualEarliestStartTime();
    }

    public int getLatestStartTime() {
        return this.getMethod().getActualLatestStartTime();
    }

    public int getEarliestFinishTime() {
        return this.getMethod().getActualEarliestFinishTime();
    }

    public int getLatestFinishTime() {
        return this.getMethod().getActualLatestFinishTime();
    }

    public Vector getQualityMonitoringInfo() {
        return this.quality_monitoring_info;
    }

    public Vector getDurationMonitoringInfo() {
        return this.duration_monitoring_info;
    }

    public ScheduleElementDisplay getDisplay() {
        return this.display;
    }

    public void setEarliestStartTime(int time) {
        int est = this.getEarliestStartTime();
        est = Math.max(est, this.getMethod().getEarliestStartTime());
        if ((est = Math.max(est, time)) != this.getEarliestStartTime()) {
            this.getMethod().setActualEarliestStartTime(est);
        }
        Enumeration e = this.dependanceto.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setEarliestStartTime(this.getEarliestFinishTime());
        }
    }

    public void setLatestFinishTime(int time) {
        int lft = this.getLatestFinishTime();
        if ((lft = Math.min(lft, time)) != this.getLatestFinishTime()) {
            this.getMethod().setActualLatestFinishTime(lft);
        }
        Enumeration e = this.dependingof.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setLatestFinishTime(this.getLatestStartTime());
        }
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public void setStartTime(Distribution d) {
        this.start_time = d;
    }

    public void setFinishTime(Distribution d) {
        this.finish_time = d;
    }

    public void setQualityDistribution(Distribution d) {
        this.quality = d;
    }

    public void setDurationDistribution(Distribution d) {
        this.duration = d;
    }

    public void setCostDistribution(Distribution d) {
        this.cost = d;
    }

    public void setQualityMonitoringInfo(Vector v) {
        this.quality_monitoring_info = v;
    }

    public void setDurationMonitoringInfo(Vector v) {
        this.duration_monitoring_info = v;
    }

    public void addPrecondition(Precondition p) {
        if (this.preconditions == null) {
            this.preconditions = new Vector();
        }
        this.preconditions.addElement(p);
        if (p.getScheduleElement() != null) {
            this.addDependingOf(p.getScheduleElement());
            p.getScheduleElement().addDependanceTo(this);
        } else {
            this.log.log("Hey why this precondition pointer is NULL", 2);
        }
    }

    public void removePrecondition(Precondition p) {
        this.preconditions.removeElement(p);
        p.clear();
        if (p.getScheduleElement() != null) {
            this.removeDependingOf(p.getScheduleElement());
            p.getScheduleElement().removeDependanceTo(this);
        }
    }

    public void addDependingOf(ScheduleElement se) {
        if (this.dependingof == null) {
            this.dependingof = new Vector();
        }
        if (!this.dependingof.contains(se)) {
            this.dependingof.addElement(se);
        }
    }

    public Vector getDependingOf() {
        return this.dependingof;
    }

    public Vector getDependanceTo() {
        return this.dependanceto;
    }

    public void addDependanceTo(ScheduleElement se) {
        if (this.dependanceto == null) {
            this.dependanceto = new Vector();
        }
        if (!this.dependanceto.contains(se)) {
            this.dependanceto.addElement(se);
        }
    }

    public void removeDependingOf(ScheduleElement se) {
        if (this.dependingof.contains(se)) {
            this.dependingof.removeElement(se);
        }
    }

    public void removeDependanceTo(ScheduleElement se) {
        if (this.dependanceto.contains(se)) {
            this.dependanceto.removeElement(se);
        }
    }

    public Enumeration getPreconditionsElement() {
        if (this.numPreconditions() <= 0) {
            return new Vector().elements();
        }
        return this.preconditions.elements();
    }

    public Vector getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.addPrecondition((Precondition)e.nextElement());
        }
    }

    public int numPreconditions() {
        return this.getPreconditions() == null ? 0 : this.getPreconditions().size();
    }

    public boolean checkPreconditions(int time) {
        Enumeration e = this.getPreconditionsElement();
        while (e.hasMoreElements()) {
            Precondition p = (Precondition)e.nextElement();
            boolean check = p.check(time);
            if (check) continue;
            return false;
        }
        return true;
    }

    public void setActualStart(int s) {
        this.actual_start = s;
    }

    public int getActualStart() {
        return this.actual_start;
    }

    public void setActualFinish(int f) {
        this.actual_finish = f;
        Enumeration e = this.getPreconditionsElement();
        while (e.hasMoreElements()) {
            Precondition p = (Precondition)e.nextElement();
            p.completed(f);
        }
    }

    public int getActualFinish() {
        return this.actual_finish;
    }

    public boolean hasStarted() {
        return this.getActualStart() != Integer.MIN_VALUE;
    }

    public boolean hasFinished() {
        return this.getActualFinish() != Integer.MIN_VALUE;
    }

    public boolean isBlocked() {
        if (this.hasFinished()) {
            if (this.getMethod() == null) {
                System.err.println("Warning: Method on " + this.getLabel() + " is null");
                return false;
            }
            return this.getMethod().getCurrentQuality() <= 0.0f;
        }
        Enumeration e = this.getDependingOf().elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (!se.isBlocked()) continue;
            return true;
        }
        return false;
    }

    public int getStart() {
        if (this.start_time == null) {
            return -1;
        }
        return (int)this.start_time.calculateMin();
    }

    public void setStart(int time) {
        this.start_time = new Distribution(new Float(time), new Float(1.0));
    }

    public int getFinish() {
        if (this.finish_time == null) {
            return -1;
        }
        return (int)this.finish_time.calculateMax();
    }

    public void setFinish(int time) {
        this.finish_time = new Distribution(new Float(time), new Float(1.0));
    }

    public float getQuality() {
        if (this.quality == null) {
            return -1.0f;
        }
        return this.quality.calculateAvg();
    }

    public float getCost() {
        if (this.cost == null) {
            return -1.0f;
        }
        return this.cost.calculateAvg();
    }

    public int getDuration() {
        if (this.duration == null) {
            return -1;
        }
        return (int)this.duration.calculateMax();
    }

    public void setSchedule(Schedule s) {
        this.schedule = s;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public Object clone() {
        ScheduleElement se;
        ScheduleElement cloned = new ScheduleElement();
        cloned.setMethod(new VirtualMethod(this.getMethod().getLabel(), this.getMethod().getAgent()));
        if (this.getStartTime() != null) {
            cloned.setStartTime((Distribution)this.getStartTime().clone());
        }
        if (this.getFinishTime() != null) {
            cloned.setFinishTime((Distribution)this.getFinishTime().clone());
        }
        if (this.getQualityDistribution() != null) {
            cloned.setQualityDistribution((Distribution)this.getQualityDistribution().clone());
        }
        if (this.getDurationDistribution() != null) {
            cloned.setDurationDistribution((Distribution)this.getDurationDistribution().clone());
        }
        if (this.getCostDistribution() != null) {
            cloned.setCostDistribution((Distribution)this.getCostDistribution().clone());
        }
        cloned.setActualStart(this.getActualStart());
        cloned.setActualFinish(this.getActualFinish());
        if (this.getQualityMonitoringInfo() != null) {
            cloned.setQualityMonitoringInfo((Vector)this.getQualityMonitoringInfo().clone());
        }
        if (this.getDurationMonitoringInfo() != null) {
            cloned.setDurationMonitoringInfo((Vector)this.getDurationMonitoringInfo().clone());
        }
        cloned.setSchedule(this.getSchedule());
        Enumeration e = this.getAttributes();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = this.getAttribute(key);
            cloned.setAttribute(key, value);
        }
        cloned.setAttribute("Cloned", new Integer(this.getID()));
        if (this.preconditions != null) {
            Vector<Object> v = new Vector<Object>();
            e = this.preconditions.elements();
            while (e.hasMoreElements()) {
                v.addElement(((Precondition)e.nextElement()).clone());
            }
            cloned.setPreconditions(v);
        }
        if (this.dependingof.size() != 0) {
            e = this.dependingof.elements();
            while (e.hasMoreElements()) {
                se = (ScheduleElement)e.nextElement();
                cloned.addDependingOf(new VirtualScheduleElement(se.getID()));
            }
        }
        if (this.dependanceto.size() != 0) {
            e = this.dependanceto.elements();
            while (e.hasMoreElements()) {
                se = (ScheduleElement)e.nextElement();
                cloned.addDependanceTo(new VirtualScheduleElement(se.getID()));
            }
        }
        cloned.bindings = false;
        cloned.display = new ScheduleElementDisplay(cloned);
        return cloned;
    }

    public void retargetVirtual(Schedule s, Vector clonedSE) {
        this.setSchedule(s);
        if (s instanceof MLCSchedule) {
            MLCSchedule mlc = (MLCSchedule)s;
            Enumeration e = this.preconditions.elements();
            while (e.hasMoreElements()) {
                Precondition p = (Precondition)e.nextElement();
                p.retargetVirtual(mlc, clonedSE);
            }
            s.retargetVirtualDependancy(this.dependingof, clonedSE);
            s.retargetVirtualDependancy(this.dependanceto, clonedSE);
        }
    }

    public Object getAttribute(Object k) {
        return this.attributes.get(k.toString());
    }

    public boolean isResourceBind() {
        return this.bindings;
    }

    public void setResourceBind(boolean b) {
        this.bindings = b;
    }

    public void setAttribute(Object k, Object d) {
        if (d == null) {
            this.removeAttribute(k);
        } else {
            this.attributes.put(k.toString(), d);
        }
    }

    public void removeAttribute(Object k) {
        this.attributes.remove(k.toString());
    }

    public Enumeration getAttributes() {
        return this.attributes.keys();
    }

    public boolean hasAttribute(Object k) {
        return this.attributes.containsKey(k.toString());
    }

    protected Hashtable getAttributesTable() {
        return this.attributes;
    }

    public boolean matches(ScheduleElement s) {
        if (s.getMethod() != null) {
            if (this.getMethod() == null) {
                return false;
            }
            if (!this.getMethod().matches(s.getMethod())) {
                return false;
            }
        }
        if (!Node.matches(s.getStartTime(), this.getStartTime())) {
            return false;
        }
        if (!Node.matches(s.getFinishTime(), this.getFinishTime())) {
            return false;
        }
        if (!Node.matches(s.getQualityDistribution(), this.getQualityDistribution())) {
            return false;
        }
        if (!Node.matches(s.getDurationDistribution(), this.getDurationDistribution())) {
            return false;
        }
        if (!Node.matches(s.getCostDistribution(), this.getCostDistribution())) {
            return false;
        }
        if (!Node.matches(s.getActualStart(), this.getActualStart())) {
            return false;
        }
        return Node.matches(s.getActualFinish(), this.getActualStart());
    }

    public String toTTaems(float v) {
        Enumeration e;
        StringBuffer sb = new StringBuffer("     (" + this.getLabel() + "\n");
        if (this.getMethod() == null) {
            sb.append(";     ** Note: method is null\n");
        } else if (this.getMethod().isVirtual()) {
            sb.append(";     ** Note: method " + this.getLabel() + " is virtual\n");
        }
        if (v >= 1.01f) {
            sb.append(Node.attributesToString(this.attributes, v));
        }
        if (this.start_time != null) {
            sb.append("        (start_time_distribution " + this.start_time.output() + ")\n");
        }
        if (this.hasStarted()) {
            sb.append(";        (actual_start " + this.getActualStart() + ")\n");
        }
        if (this.finish_time != null) {
            sb.append("        (finish_time_distribution " + this.finish_time.output() + ")\n");
        }
        if (this.hasFinished()) {
            sb.append(";        (actual_finish " + this.getActualFinish() + ")\n");
        }
        if (this.quality != null) {
            sb.append("        (quality_distribution " + this.quality.output() + ")\n");
        }
        if (this.duration != null) {
            sb.append("        (duration_distribution " + this.duration.output() + ")\n");
        }
        if (this.cost != null) {
            sb.append("        (cost_distribution " + this.cost.output() + ")\n");
        }
        if (this.quality_monitoring_info != null) {
            sb.append("        (quality_monitoring_info ");
            e = this.quality_monitoring_info.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString() + " ");
            }
            sb.append(")\n");
        }
        if (this.duration_monitoring_info != null) {
            sb.append("        (duration_monitoring_info ");
            e = this.duration_monitoring_info.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString() + " ");
            }
            sb.append(")\n");
        }
        if (this.numPreconditions() > 0 && v >= 1.1f) {
            sb.append("        (preconditions\n");
            sb.append(";         " + this.numPreconditions() + " precondition(s)\n");
            e = this.getPreconditionsElement();
            while (e.hasMoreElements()) {
                Precondition p = (Precondition)e.nextElement();
                sb.append(p.toTTaems(v));
            }
            sb.append("        )\n");
        }
        sb.append("     )\n");
        return sb.toString();
    }

    public String stringify() {
        String print = "";
        boolean ANSI = false;
        if (this.hasFinished()) {
            ANSI = true;
            print = print + "\u001b[" + "37m";
        } else if (this.hasStarted()) {
            ANSI = true;
            print = print + "\u001b[" + "32m";
        }
        print = print + " [ (";
        print = this.getEarliestStartTime() == Integer.MIN_VALUE ? print + "?, " : print + this.getEarliestStartTime() + ", ";
        print = this.getLatestStartTime() == Integer.MIN_VALUE ? print + "?) " : print + this.getLatestStartTime() + ") ";
        print = print + this.getStart() + " - " + this.getLabel() + " - " + this.getFinish() + " (";
        print = this.getEarliestFinishTime() == Integer.MAX_VALUE ? print + "?, " : print + this.getEarliestFinishTime() + ", ";
        print = this.getLatestFinishTime() == Integer.MAX_VALUE ? print + "?) ]" : print + this.getLatestFinishTime() + ") ] ";
        if (ANSI) {
            print = print + "\u001b[m";
        }
        return print;
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }

    public int compareTo(Object o) {
        if (!(o instanceof ScheduleElement)) {
            throw new ClassCastException();
        }
        ScheduleElement e = (ScheduleElement)o;
        if (this.getStart() < e.getStart()) {
            return -1;
        }
        if (this.getStart() > e.getStart()) {
            return 1;
        }
        if (this.getFinish() < e.getFinish()) {
            return -1;
        }
        if (this.getFinish() > e.getFinish()) {
            return 1;
        }
        return this.getLabel().compareTo(e.getLabel());
    }

    public int getOptimalEarliestStartTime() {
        if (this.hasAttribute("OEST")) {
            return (Integer)this.getAttribute("OEST");
        }
        return Integer.MIN_VALUE;
    }

    public int getOptimalLatestStartTime() {
        if (this.hasAttribute("OLST")) {
            return (Integer)this.getAttribute("OLST");
        }
        return Integer.MIN_VALUE;
    }

    public int getOptimalEarliestFinishTime() {
        if (this.hasAttribute("OEFT")) {
            return (Integer)this.getAttribute("OEFT");
        }
        return Integer.MAX_VALUE;
    }

    public int getOptimalLatestFinishTime() {
        if (this.hasAttribute("OLFT")) {
            return (Integer)this.getAttribute("OLFT");
        }
        return Integer.MAX_VALUE;
    }

    public void resetPropagation() {
        if (!propagationList.contains(this)) {
            ScheduleElement se;
            propagationList.add(this);
            int recursion = propagationList.size();
            String print = "\t";
            for (int i = 0; i < recursion; ++i) {
                print = print + "\t";
            }
            if (this.updated) {
                this.updated = false;
            }
            int est = this.getOptimalEarliestStartTime();
            int eft = this.getOptimalEarliestFinishTime();
            int lst = this.getOptimalLatestStartTime();
            int lft = this.getOptimalLatestFinishTime();
            if (this.log.getLogLevel() > 2) {
                this.log.log(print + "This = " + this.stringify(), 3);
            }
            Enumeration e = this.dependingof.elements();
            while (e.hasMoreElements()) {
                se = (ScheduleElement)e.nextElement();
                if (this.log.getLogLevel() > 2) {
                    this.log.log(print + "<- se = " + se.stringify());
                }
                se.resetPropagation();
                if (this.log.getLogLevel() > 2) {
                    this.log.log(print + "<- se = " + se.stringify());
                }
                if (se.getOptimalEarliestFinishTime() != Integer.MAX_VALUE) {
                    est = Math.max(est, se.getOptimalEarliestFinishTime());
                }
                if (se.getOptimalLatestFinishTime() == Integer.MAX_VALUE) continue;
                lst = Math.max(lst, se.getOptimalLatestFinishTime());
            }
            e = this.dependanceto.elements();
            while (e.hasMoreElements()) {
                se = (ScheduleElement)e.nextElement();
                if (this.log.getLogLevel() > 2) {
                    this.log.log(print + "-> se = " + se.stringify());
                }
                se.resetPropagation();
                if (this.log.getLogLevel() > 2) {
                    this.log.log(print + "-> se = " + se.stringify());
                }
                if (se.getOptimalEarliestStartTime() != Integer.MIN_VALUE) {
                    eft = Math.min(eft, se.getOptimalEarliestStartTime());
                }
                if (se.getOptimalLatestStartTime() == Integer.MIN_VALUE) continue;
                lft = Math.min(lft, se.getOptimalLatestStartTime());
            }
            if (this.log.getLogLevel() > 2) {
                this.log.log(print + "est = " + est);
                this.log.log(print + "eft = " + eft);
                this.log.log(print + "lst = " + lst);
                this.log.log(print + "lft = " + lft);
            }
            if (est != this.getOptimalEarliestStartTime()) {
                this.setOEST(est);
            } else if (eft != this.getOptimalEarliestFinishTime()) {
                this.setOEFT(eft);
            }
            if (lst != this.getOptimalLatestStartTime()) {
                this.setOLST(lst);
            } else if (lft != this.getOptimalLatestFinishTime()) {
                this.setOLFT(lft);
            }
            propagationList.removeElement(this);
        }
    }

    private void setOptimalEarliestStartTime(int time) {
        this.setOEST(time);
        Enumeration e = this.dependingof.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setOptimalEarliestFinishTime(this.getOptimalEarliestStartTime(), false);
        }
    }

    public void setOptimalEarliestStartTime(int time, boolean propagation) {
        if (!this.updated) {
            this.updated = true;
            this.setOptimalEarliestStartTime(time);
            this.setOptimalEarliestFinishTime(this.getOptimalEarliestFinishTime());
        }
        if (propagation) {
            this.resetPropagation();
        }
    }

    private void setOptimalEarliestFinishTime(int time) {
        this.setOEFT(time);
        Enumeration e = this.dependanceto.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setOptimalEarliestStartTime(this.getOptimalEarliestFinishTime(), false);
        }
    }

    public void setOptimalEarliestFinishTime(int time, boolean propagation) {
        if (!this.updated) {
            this.updated = true;
            this.setOptimalEarliestFinishTime(time);
            this.setOptimalEarliestStartTime(this.getOptimalEarliestStartTime());
        }
        if (propagation) {
            this.resetPropagation();
        }
    }

    private void setOptimalLatestStartTime(int time) {
        this.setOLST(time);
        Enumeration e = this.dependingof.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setOptimalLatestFinishTime(this.getOptimalLatestStartTime(), false);
        }
    }

    public void setOptimalLatestStartTime(int time, boolean propagation) {
        if (!this.updated) {
            this.updated = true;
            this.setOptimalLatestStartTime(time);
            this.setOptimalLatestFinishTime(this.getOptimalLatestFinishTime());
        }
        if (propagation) {
            this.resetPropagation();
        }
    }

    private void setOptimalLatestFinishTime(int time) {
        this.setOLFT(time);
        Enumeration e = this.dependanceto.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setOptimalLatestStartTime(this.getOptimalLatestFinishTime(), false);
        }
    }

    public void setOptimalLatestFinishTime(int time, boolean propagation) {
        if (!this.updated) {
            this.updated = true;
            this.setOptimalLatestFinishTime(time);
            this.setOptimalLatestStartTime(this.getOptimalLatestStartTime());
        }
        if (propagation) {
            this.resetPropagation();
        }
    }

    private void setOEST(int time) {
        int value = time;
        if (time < 0) {
            this.log.log("Warning someone is trying to set a negative OEST (" + time + ") Ignoring it OEST set to 0 for SE " + this.getLabel(), 1);
            value = 0;
        }
        this.setAttribute("OEST", new Integer(value));
        this.setAttribute("OEFT", new Integer(value + (int)this.getMethod().getGlobalOutcome().getDuration().calculateMin()));
    }

    private void setOEFT(int time) {
        int valueEFT = time;
        int valueEST = time - (int)this.getMethod().getGlobalOutcome().getDuration().calculateMin();
        if (valueEST < 0) {
            this.log.log("Warning someone is trying to set a incorrect OEFT (" + time + ") that will create an negative OEST (" + valueEST + ") Ignoring it OEFT set to " + (time - valueEST) + " for SE " + this.getLabel(), 1);
            valueEFT = (int)this.getMethod().getGlobalOutcome().getDuration().calculateMin();
            valueEST = 0;
        }
        this.setAttribute("OEFT", new Integer(valueEFT));
        this.setAttribute("OEST", new Integer(valueEST));
    }

    private void setOLST(int time) {
        this.setAttribute("OLST", new Integer(time));
        this.setAttribute("OLFT", new Integer(time + (int)this.getMethod().getGlobalOutcome().getDuration().calculateMax()));
    }

    private void setOLFT(int time) {
        this.setAttribute("OLFT", new Integer(time));
        this.setAttribute("OLST", new Integer(time - (int)this.getMethod().getGlobalOutcome().getDuration().calculateMax()));
    }
}

