/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import taems.Schedule;
import taems.ScheduleElement;
import taems.ScheduleElementDisplay;

public class ScheduleDisplay
extends Panel
implements MouseListener {
    protected Schedule schedule;
    protected Point localisation;
    protected Vector scheduleElements;
    protected int timeIncrement = 1;

    public ScheduleDisplay(Schedule s) {
        this.schedule = s;
        this.scheduleElements = new Vector();
        this.addMouseListener(this);
        Enumeration e = s.getScheduleElements().elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            this.scheduleElements.addElement(se.getDisplay());
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public int getTimeIncrement() {
        return this.timeIncrement;
    }

    public void setTimeIncrement(int time) {
        this.timeIncrement = time;
        this.update(null, true);
    }

    public void update() {
        this.update(null, false);
    }

    public void update(Graphics g, boolean force) {
        if (force) {
            Enumeration e = this.scheduleElements.elements();
            int x = this.localisation.x;
            int y = this.localisation.y;
            while (e.hasMoreElements()) {
                ScheduleElementDisplay se = (ScheduleElementDisplay)e.nextElement();
                se.setLocation(new Point(x, y));
                x += se.getSize((Graphics)g).width;
            }
        }
    }

    public void setLocation(Point d) {
        this.localisation = d;
        this.update(null, true);
    }

    public void paint(Graphics g) {
        this.update(g, false);
        Enumeration e = this.scheduleElements.elements();
        while (e.hasMoreElements()) {
            ScheduleElementDisplay se = (ScheduleElementDisplay)e.nextElement();
            se.paint(g);
        }
    }

    public void setSize(Dimension d) {
        int incT = d.width / this.schedule.getTotalDuration();
        this.setTimeIncrement(incT);
    }
}

