/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import taems.MLCSchedule;
import taems.Node;
import taems.PrecedencePrecondition;
import taems.Precondition;
import taems.ScheduleDisplay;
import taems.ScheduleElement;
import taems.VirtualScheduleElement;
import utilities.Distribution;

public class Schedule
implements Serializable,
Cloneable {
    protected final int CLUSTERING = 3;
    protected Vector schedule_elements = new Vector();
    protected Vector task_quality_info;
    protected Vector commitment_info;
    protected Distribution quality;
    protected Distribution duration;
    protected Distribution cost;
    protected Distribution finish;
    protected Distribution start;
    protected double rating = Double.NEGATIVE_INFINITY;
    protected ScheduleDisplay display;

    public Schedule(Vector se, Vector tqi, Vector ci, Distribution qd, Distribution dd, Distribution cd) {
        this.schedule_elements = se;
        this.task_quality_info = tqi;
        this.commitment_info = ci;
        this.quality = qd;
        this.duration = dd;
        this.cost = cd;
    }

    public Schedule() {
        this.schedule_elements = new Vector();
        this.task_quality_info = null;
        this.commitment_info = null;
        this.quality = null;
        this.duration = null;
        this.cost = null;
    }

    public void setTaskQualityInfo(Vector s) {
        this.task_quality_info = s;
    }

    public Vector getTaskQualityInfo() {
        return this.task_quality_info;
    }

    public void setCommitmentInfo(Vector s) {
        this.commitment_info = s;
    }

    public Vector getCommitmentInfo() {
        return this.commitment_info;
    }

    public void setQuality(Distribution d) {
        this.quality = d;
    }

    public Distribution getQuality() {
        return this.quality;
    }

    public void setDuration(Distribution d) {
        this.duration = d;
    }

    public Distribution getDuration() {
        return this.duration;
    }

    public void setCost(Distribution d) {
        this.cost = d;
    }

    public Distribution getCost() {
        return this.cost;
    }

    public void setRating(double d) {
        this.rating = d;
    }

    public double getRating() {
        return this.rating;
    }

    public Enumeration getElements() {
        if (this.getScheduleElements() != null) {
            return this.getScheduleElements().elements();
        }
        return new Vector(0).elements();
    }

    public Enumeration getElementsSorted() {
        return this.sortElements(this.getScheduleElements());
    }

    protected Enumeration sortElements(Vector se) {
        if (se == null) {
            return new Vector(0).elements();
        }
        Vector<ScheduleElement> v = new Vector<ScheduleElement>(se.size());
        for (int i = 0; i < se.size(); ++i) {
            int j;
            ScheduleElement n = (ScheduleElement)se.elementAt(i);
            for (j = 0; j < v.size(); ++j) {
                ScheduleElement c = (ScheduleElement)v.elementAt(j);
                if (n.getStart() <= c.getStart()) break;
            }
            v.insertElementAt(n, j);
        }
        return v.elements();
    }

    public void removeAllElements() {
        this.schedule_elements.removeAllElements();
    }

    public Vector getScheduleElements() {
        return this.schedule_elements;
    }

    public void setScheduleElements(Vector v) {
        this.schedule_elements = v;
        Enumeration e = this.getScheduleElements().elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.setSchedule(this);
        }
    }

    public void insertScheduleElement(ScheduleElement e, int i) {
        this.schedule_elements.insertElementAt(e, i);
        e.setSchedule(this);
    }

    public void addScheduleElement(ScheduleElement e) {
        this.schedule_elements.addElement(e);
        e.setSchedule(this);
    }

    public void removeScheduleElement(ScheduleElement e) {
        this.schedule_elements.removeElement(e);
        e.setSchedule(null);
    }

    public ScheduleElement getScheduleElement(String l) {
        Enumeration list = this.getElements();
        while (list.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)list.nextElement();
            if (!se.getLabel().equals(l)) continue;
            return se;
        }
        return null;
    }

    public ScheduleElement getNextTask(int time) {
        Enumeration list = this.getNextTasks(time);
        if (list != null && list.hasMoreElements()) {
            return (ScheduleElement)list.nextElement();
        }
        return null;
    }

    public Enumeration getNextTasks(int time) {
        Enumeration list = this.getElements();
        Vector<ScheduleElement> answer = new Vector<ScheduleElement>();
        while (list.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)list.nextElement();
            if (se.hasStarted()) continue;
            if (se.getStartTime() == null || se.getStartTime().containsValue(-1.0f, 0.0f)) {
                answer.addElement(se);
                break;
            }
            if (!se.getStartTime().containsValue(time, 0.0f) && time < se.getStart()) continue;
            answer.addElement(se);
        }
        return this.sortElements(answer);
    }

    public boolean isStarted() {
        Enumeration list = this.getElements();
        while (list.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)list.nextElement();
            if (!se.hasStarted()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompleted() {
        ScheduleElement se;
        Vector v = this.getScheduleElements();
        if (v != null && v.size() > 0 && !(se = (ScheduleElement)v.lastElement()).hasFinished()) {
            return false;
        }
        Enumeration list = this.getElements();
        while (list.hasMoreElements()) {
            se = (ScheduleElement)list.nextElement();
            if (se.hasFinished()) continue;
            return false;
        }
        return true;
    }

    public boolean isBlocked() {
        if (this.isCompleted()) {
            return true;
        }
        Enumeration list = this.getElements();
        while (list.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)list.nextElement();
            if (se.hasFinished() || se.isBlocked()) continue;
            return false;
        }
        return true;
    }

    public ScheduleElement getScheduleElement(int i) {
        return (ScheduleElement)this.schedule_elements.elementAt(i);
    }

    public int getScheduleElementIndex(ScheduleElement se) {
        return this.schedule_elements.indexOf(se);
    }

    public int size() {
        if (this.schedule_elements != null) {
            return this.schedule_elements.size();
        }
        return 0;
    }

    public boolean containsTask(String l) {
        Enumeration list = this.getElements();
        while (list.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)list.nextElement();
            if (!se.getLabel().equals(l)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTask(ScheduleElement se) {
        return this.schedule_elements.contains(se);
    }

    public void setStartTime(int s) {
        Enumeration e = this.getScheduleElements().elements();
        if (e.hasMoreElements()) {
            int offset = s - this.getScheduleElement(0).getStart();
            if (this.start != null) {
                this.setStart(this.getStart().applyOffset(offset));
            }
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                se.setStartTime(se.getStartTime().applyOffset(offset));
                se.setFinishTime(se.getFinishTime().applyOffset(offset));
            }
        }
    }

    public void setStart(Distribution d) {
        this.start = d;
    }

    public Vector delayFinishTime(ScheduleElement schelement, int s) {
        boolean needToDelayed = false;
        Vector<ScheduleElement> v = new Vector<ScheduleElement>();
        Enumeration e = this.getScheduleElements().elements();
        if (e.hasMoreElements()) {
            int offset = s;
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (se == schelement) {
                    needToDelayed = true;
                    if (!schelement.hasAttribute("FinishTime")) {
                        se.setAttribute("FinishTime", se.getFinishTime());
                    }
                    se.setFinishTime(se.getFinishTime().applyOffset(offset));
                    if (!schelement.hasAttribute("DurationDistribution")) {
                        se.setAttribute("DurationDistribution", se.getDurationDistribution());
                    }
                    se.setDurationDistribution(se.getDurationDistribution().applyOffset(offset));
                    continue;
                }
                if (!needToDelayed) continue;
                if (!schelement.hasAttribute("StartTime")) {
                    se.setAttribute("StartTime", se.getStartTime());
                }
                se.setStartTime(se.getStartTime().applyOffset(offset));
                if (!schelement.hasAttribute("FinishTime")) {
                    se.setAttribute("FinishTime", se.getFinishTime());
                }
                se.setFinishTime(se.getFinishTime().applyOffset(offset));
                v.addElement(se);
            }
        }
        return v;
    }

    public Vector delayStartTime(ScheduleElement schelement, int s) {
        boolean needToDelayed = false;
        Vector<ScheduleElement> v = new Vector<ScheduleElement>();
        Enumeration e = this.getScheduleElements().elements();
        if (e.hasMoreElements()) {
            int offset = s;
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (se == schelement) {
                    needToDelayed = true;
                }
                if (!needToDelayed) continue;
                se.setAttribute("StartTime", se.getStartTime());
                se.setStartTime(se.getStartTime().applyOffset(offset));
                se.setAttribute("FinishTime", se.getFinishTime());
                se.setFinishTime(se.getFinishTime().applyOffset(offset));
                v.addElement(se);
            }
        }
        return v;
    }

    public void undeleteTiming(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            this.undeleteTiming(se);
        }
    }

    public void undeleteTiming(ScheduleElement se) {
        Distribution d;
        if (se.hasAttribute("StartTime")) {
            d = (Distribution)se.getAttribute("StartTime");
            se.setStartTime(d);
            se.removeAttribute("StartTime");
        }
        if (se.hasAttribute("FinishTime")) {
            d = (Distribution)se.getAttribute("FinishTime");
            se.setFinishTime(d);
            se.removeAttribute("FinishTime");
        }
    }

    public void deleteHistory(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            this.deleteHistory(se);
        }
    }

    public void deleteHistory(ScheduleElement se) {
        if (se.hasAttribute("StartTime")) {
            se.removeAttribute("StartTime");
        }
        if (se.hasAttribute("FinishTime")) {
            se.removeAttribute("FinishTime");
        }
        if (se.hasAttribute("DurationDistribution")) {
            se.removeAttribute("DurationDistribution");
        }
    }

    public void setFinish(Distribution d) {
        this.finish = d;
    }

    public int getStartTime() {
        if (this.start == null) {
            if (this.size() > 0) {
                ScheduleElement se = (ScheduleElement)this.getScheduleElements().firstElement();
                return se.getStart();
            }
            return -1;
        }
        return (int)this.start.calculateMin();
    }

    public Distribution getStart() {
        return this.start;
    }

    public int getFinishTime() {
        if (this.finish == null) {
            ScheduleElement se = (ScheduleElement)this.getScheduleElements().lastElement();
            return se.getFinish();
        }
        return (int)this.finish.calculateMax();
    }

    public Distribution getFinish() {
        return this.finish;
    }

    public int getTotalDuration() {
        if (this.duration == null) {
            ScheduleElement se = (ScheduleElement)this.getScheduleElements().lastElement();
            return se.getFinish() - this.getStartTime();
        }
        return (int)this.getDuration().calculateMax();
    }

    public void fixConditions(Schedule query) {
        if (query == null) {
            query = this;
        }
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            Enumeration pree = se.getPreconditionsElement();
            while (pree.hasMoreElements()) {
                ScheduleElement x;
                Precondition p = (Precondition)pree.nextElement();
                if (this instanceof MLCSchedule) {
                    p.setParentMLC((MLCSchedule)this);
                }
                if (!(p instanceof PrecedencePrecondition) || (x = query.getScheduleElement(((PrecedencePrecondition)p).getScheduleElement().getLabel())) == null) continue;
                ((PrecedencePrecondition)p).setScheduleElement(x);
            }
        }
    }

    public Object clone() {
        Schedule cloned = new Schedule();
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            cloned.addScheduleElement((ScheduleElement)((ScheduleElement)e.nextElement()).clone());
        }
        if (this.task_quality_info != null) {
            cloned.setTaskQualityInfo((Vector)this.task_quality_info.clone());
        }
        if (this.commitment_info != null) {
            cloned.setCommitmentInfo((Vector)this.commitment_info.clone());
        }
        if (this.getQuality() != null) {
            cloned.setQuality((Distribution)this.getQuality().clone());
        }
        if (this.getDuration() != null) {
            cloned.setDuration((Distribution)this.getDuration().clone());
        }
        if (this.getCost() != null) {
            cloned.setCost((Distribution)this.getCost().clone());
        }
        cloned.setRating(this.getRating());
        if (this.getStart() != null) {
            cloned.setStart((Distribution)this.getStart().clone());
        }
        if (this.getFinish() != null) {
            cloned.setFinish((Distribution)this.getFinish().clone());
        }
        cloned.display = this.display;
        e = cloned.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            se.retargetVirtual(cloned, cloned.schedule_elements);
        }
        return cloned;
    }

    protected Object cloneWithVirtual() {
        Schedule cloned = new Schedule();
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            cloned.addScheduleElement(new VirtualScheduleElement(((ScheduleElement)e.nextElement()).getID()));
        }
        if (this.task_quality_info != null) {
            cloned.setTaskQualityInfo((Vector)this.task_quality_info.clone());
        }
        if (this.commitment_info != null) {
            cloned.setCommitmentInfo((Vector)this.commitment_info.clone());
        }
        if (this.getQuality() != null) {
            cloned.setQuality((Distribution)this.getQuality().clone());
        }
        if (this.getDuration() != null) {
            cloned.setDuration((Distribution)this.getDuration().clone());
        }
        if (this.getCost() != null) {
            cloned.setCost((Distribution)this.getCost().clone());
        }
        cloned.setRating(this.getRating());
        if (this.getStart() != null) {
            cloned.setStart((Distribution)this.getStart().clone());
        }
        if (this.getFinish() != null) {
            cloned.setFinish((Distribution)this.getFinish().clone());
        }
        cloned.display = this.display;
        return cloned;
    }

    protected void retargetVirtual(Vector clonedSE) {
        this.retargetVirtualDependancy(this.schedule_elements, clonedSE);
    }

    protected void retargetVirtualDependancy(Vector dependance, Vector clonedSE) {
        Vector<ScheduleElement> toberemoved = new Vector<ScheduleElement>();
        Vector<ScheduleElement> tobereplaced = new Vector<ScheduleElement>();
        Enumeration e1 = dependance.elements();
        while (e1.hasMoreElements()) {
            ScheduleElement se1 = (ScheduleElement)e1.nextElement();
            if (!(se1 instanceof VirtualScheduleElement)) continue;
            Enumeration e = clonedSE.elements();
            while (e.hasMoreElements()) {
                ScheduleElement se = (ScheduleElement)e.nextElement();
                if (!((VirtualScheduleElement)se1).matches(se)) continue;
                if (!tobereplaced.contains(se)) {
                    tobereplaced.add(se);
                }
                toberemoved.addElement(se1);
            }
        }
        e1 = toberemoved.elements();
        while (e1.hasMoreElements()) {
            dependance.removeElement(e1.nextElement());
        }
        e1 = tobereplaced.elements();
        while (e1.hasMoreElements()) {
            dependance.addElement(e1.nextElement());
        }
    }

    public boolean matches(Schedule s) {
        if (s.size() != this.size()) {
            return false;
        }
        if (!Node.matches(s.getStart(), this.getStart())) {
            return false;
        }
        if (!Node.matches(s.getFinish(), this.getFinish())) {
            return false;
        }
        if (!Node.matches(s.getQuality(), this.getQuality())) {
            return false;
        }
        if (!Node.matches(s.getDuration(), this.getDuration())) {
            return false;
        }
        if (!Node.matches(s.getCost(), this.getCost())) {
            return false;
        }
        if (!Node.matches(s.getRating(), this.getRating())) {
            return false;
        }
        Enumeration e1 = this.getElements();
        Enumeration e2 = s.getElements();
        while (e1.hasMoreElements()) {
            ScheduleElement se2;
            ScheduleElement se1 = (ScheduleElement)e1.nextElement();
            if (se1.matches(se2 = (ScheduleElement)e2.nextElement())) continue;
            return false;
        }
        return true;
    }

    protected void calculateDuration() {
        Vector<Distribution> v_duration = new Vector<Distribution>();
        Vector<Distribution> s_duration = new Vector<Distribution>();
        float value = 0.0f;
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement se = (ScheduleElement)e.nextElement();
            if (!se.hasFinished()) {
                v_duration.addElement(se.getFinishTime());
            }
            s_duration.addElement(se.getStartTime());
        }
        Distribution d = Distribution.computeMaxJointDistribution(v_duration);
        Distribution d1 = Distribution.computeMinJointDistribution(s_duration);
        Distribution d2 = Distribution.computeDifferenceJointDistribution(d, d1);
        d2.cluster(3);
        this.setStart(d1);
        this.setFinish(d);
        this.setDuration(d2);
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }

    public String stringify() {
        String print = "";
        Enumeration e = this.getElements();
        while (e.hasMoreElements()) {
            ScheduleElement schElement = (ScheduleElement)e.nextElement();
            print = print + schElement.stringify();
        }
        return print;
    }

    public String toTTaems(float v) {
        Enumeration e;
        StringBuffer sb = new StringBuffer("(spec_schedule\n");
        sb.append("; Schedule contains " + this.size() + " schedule element(s)\n");
        if (this.schedule_elements != null) {
            sb.append("   (schedule_elements\n");
            e = this.getElements();
            while (e.hasMoreElements()) {
                sb.append(((ScheduleElement)e.nextElement()).toTTaems(v));
            }
            sb.append("   )\n");
        }
        if (this.task_quality_info != null) {
            sb.append("   (task_quality_infos ");
            e = this.task_quality_info.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString() + " ");
            }
            sb.append(")\n");
        }
        if (this.commitment_info != null) {
            sb.append("   (commitment_info " + this.commitment_info.toString() + ")\n");
        }
        if (this.quality != null) {
            sb.append("   (quality_distribution " + this.quality.output() + ")\n");
        }
        if (this.duration != null) {
            sb.append("   (duration_distribution " + this.duration.output() + ")\n");
        }
        if (this.cost != null) {
            sb.append("   (cost_distribution " + this.cost.output() + ")\n");
        }
        if (this.rating != Double.NEGATIVE_INFINITY) {
            sb.append("   (rating " + this.rating + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }

    public int getTimeIncrement() {
        return this.display.getTimeIncrement();
    }

    public ScheduleDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ScheduleDisplay sd) {
        this.display = sd;
    }

    public void init() {
    }
}

