/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import taems.Agent;
import taems.Node;
import taems.NodeUpdateEvent;
import taems.Taems;

public class Resource
extends Node
implements Serializable,
Cloneable {
    protected double state = Double.NEGATIVE_INFINITY;
    protected double depleted_at = Double.NEGATIVE_INFINITY;
    protected double overloaded_at = Double.NEGATIVE_INFINITY;
    protected Agent agent = null;
    private Polygon poly;

    public Resource(String l, Agent a, double s, double d, double o) {
        super(l);
        this.setAgent(a);
        this.setDepletedAt(d);
        this.setOverloadedAt(o);
        this.setState(s);
    }

    public Resource(String l, Agent a) {
        this(l, a, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public Resource() {
        this(null, null);
    }

    public double getState() {
        return this.state;
    }

    public void setState(double s) {
        if (this.getState() == s) {
            return;
        }
        this.state = s;
        this.updateStatus();
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public double getDepletedAt() {
        return this.depleted_at;
    }

    public void setDepletedAt(double d) {
        if (this.getDepletedAt() == d) {
            return;
        }
        this.depleted_at = d;
        this.updateStatus();
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public boolean isDepleted() {
        return this.getState() < this.getDepletedAt();
    }

    public double getOverloadedAt() {
        return this.overloaded_at;
    }

    public void setOverloadedAt(double o) {
        if (this.getOverloadedAt() == o) {
            return;
        }
        this.overloaded_at = o;
        this.updateStatus();
        this.fireNodeUpdateEvent(new NodeUpdateEvent(this, 0));
    }

    public boolean isOverloaded() {
        return this.getState() > this.getOverloadedAt();
    }

    protected void updateStatus() {
        if (this.isDepleted()) {
            if (this.getState() == Double.NEGATIVE_INFINITY) {
                this.setStatus(6);
            } else {
                this.setStatus(5);
            }
        } else if (this.isOverloaded()) {
            this.setStatus(4);
        } else {
            this.setStatus(0);
        }
    }

    public boolean isNormalState(double s) {
        if (s > this.getDepletedAt()) {
            if (s < this.getOverloadedAt()) {
                return true;
            }
            if (Double.isInfinite(this.getOverloadedAt())) {
                return true;
            }
        }
        return false;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        Agent saveagent = this.getAgent();
        if (v < 1.1f) {
            this.setAgent(null);
        }
        sb.append(super.toTTaems(v));
        if (v < 1.1f) {
            this.setAgent(saveagent);
        }
        sb.append("   (state " + this.getState() + ")\n");
        sb.append("   (depleted_at " + this.getDepletedAt() + ")\n");
        sb.append(";  ** Status is: " + this.getStatus() + "\n");
        if (v >= 1.1f) {
            sb.append("   (overloaded_at " + this.getOverloadedAt() + ")\n");
        }
        return sb.toString();
    }

    public boolean matches(Node n) {
        if (n.getClass().isInstance(this)) {
            if (!super.matches(n)) {
                return false;
            }
        } else {
            return false;
        }
        if (n instanceof Resource) {
            if (!Resource.matches(((Resource)n).getState(), this.getState())) {
                return false;
            }
            if (!Resource.matches(((Resource)n).getDepletedAt(), this.getDepletedAt())) {
                return false;
            }
            if (!Resource.matches(((Resource)n).getOverloadedAt(), this.getOverloadedAt())) {
                return false;
            }
        }
        return true;
    }

    public void copy(Node n) {
        if (n instanceof Resource) {
            Resource r = (Resource)n;
            r.setState(this.getState());
            r.setDepletedAt(this.getDepletedAt());
            r.setOverloadedAt(this.getOverloadedAt());
        }
        super.copy(n);
    }

    public Object clone() {
        Resource cloned = null;
        try {
            cloned = (Resource)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        cloned.setState(this.getState());
        cloned.setDepletedAt(this.getDepletedAt());
        cloned.setOverloadedAt(this.getOverloadedAt());
        return cloned;
    }

    public Rectangle getBounds() {
        if (this.poly != null) {
            return this.poly.getBounds();
        }
        return null;
    }

    public boolean contains(Point p) {
        if (this.isHidden()) {
            return false;
        }
        if (this.poly != null) {
            return this.poly.contains(p);
        }
        return false;
    }

    public void updateBounds(FontMetrics fm) {
        int x = this.loc.x;
        int y = this.loc.y;
        int w = this.calculateWidth(fm);
        int h = this.calculateHeight(fm);
        this.poly = new Polygon();
        this.poly.addPoint(this.loc.x - w / 2, this.loc.y - h / 2);
        this.poly.addPoint(this.loc.x + w / 2, this.loc.y - h / 2);
        this.poly.addPoint(this.loc.x, this.loc.y + h / 2);
    }

    public void paint(Graphics g) {
        g.setFont(normalFont);
        FontMetrics fm = g.getFontMetrics();
        int x = this.loc.x;
        int y = this.loc.y;
        int w = this.calculateWidth(fm);
        int h = this.calculateHeight(fm);
        this.updateBounds(fm);
        if (!this.isHidden()) {
            g.setColor(this.getBackground());
            g.fillPolygon(this.poly);
            double s = this.getState();
            double o = this.getOverloadedAt();
            double d = this.getDepletedAt();
            if (s != Double.NEGATIVE_INFINITY && o != Double.NEGATIVE_INFINITY) {
                if (d == Double.NEGATIVE_INFINITY) {
                    d = 0.0;
                }
                Rectangle bounds = this.poly.getBounds();
                int l = Math.min((int)Math.round((double)bounds.height * ((s - d) / (o - d))), bounds.height);
                l = Math.max(l, 0);
                double tx1 = bounds.x;
                double ty1 = bounds.y;
                double tx2 = bounds.x + bounds.width / 2;
                double ty2 = bounds.y + bounds.height;
                double lx1 = bounds.x;
                double ly1 = bounds.y + bounds.height - l;
                double lx2 = bounds.x + bounds.width;
                double ly2 = bounds.y + bounds.height - l;
                double tb = (ty2 - ty1) / (tx2 - tx1);
                double lb = (ly2 - ly1) / (lx2 - lx1);
                double ta = ty1 - tb * tx1;
                double la = ly1 - lb * lx1;
                int x1 = (int)Math.round(-(ta - la) / (tb - lb));
                int x2 = (int)Math.round(tx2 + (tx2 - (double)x1));
                int yi = (int)Math.round(ta + tb * (double)x1);
                if (this.isSelected()) {
                    g.setColor(this.getBackground());
                } else {
                    g.setColor(Color.pink);
                }
                Polygon p = new Polygon();
                p.addPoint(x1, yi);
                p.addPoint(x2, yi);
                p.addPoint((int)tx2, (int)ty2);
                g.fillPolygon(p);
            }
            g.setColor(Color.black);
            g.drawPolygon(this.poly);
            String str = this.getLabel();
            while (fm.stringWidth(str) > w - 10) {
                str = str.substring(0, str.length() - 1);
            }
            try {
                g.drawString(str, x - fm.stringWidth(str) / 2, y - (h - 4) / 2 + fm.getAscent());
                g.setFont(smallFont);
                fm = g.getFontMetrics();
                if (s != Double.NEGATIVE_INFINITY && o != Double.NEGATIVE_INFINITY) {
                    String num = String.valueOf(this.getDepletedAt() + " / " + this.getState() + " / " + this.getOverloadedAt());
                    if (Taems.printing) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(Color.gray);
                    }
                    g.drawString(num, x - fm.stringWidth(num) / 2, this.loc.y + h / 2 + 2 + fm.getAscent());
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.err.println("Error drawing label");
            }
        }
        g.setFont(normalFont);
        Enumeration e = this.getOutInterrelationships();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            n.paint(g);
        }
    }

    public int calculateWidth(FontMetrics fm) {
        return 70;
    }

    public int calculateHeight(FontMetrics fm) {
        return 60;
    }
}

