/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Agent;
import taems.Interrelationship;
import taems.Method;
import taems.Outcome;
import taems.Resource;
import utilities.Distribution;
import utilities.Log;
import utilities.TaemsRandom;

public class ProducesInterrelationship
extends Interrelationship
implements Serializable,
Cloneable {
    public ProducesInterrelationship(String l, Agent a, Distribution c, String m) {
        super(l, a, null, null, null, null);
        this.setProduces(c);
        this.setModel(m);
    }

    public ProducesInterrelationship(String l, Agent a, Distribution c) {
        this(l, a, c, "per_time_unit");
    }

    public ProducesInterrelationship() {
    }

    public void setProduces(Distribution p) {
        this.setCost(p);
    }

    public Distribution getProduces() {
        return this.getCost();
    }

    public boolean hasModel() {
        return true;
    }

    public Outcome applyNLEonOutcome(Outcome o, boolean complex, TaemsRandom tr) {
        return o;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("");
        if (this.getFrom() != null && !this.getFrom().isVirtual() && !(this.getFrom() instanceof Method)) {
            Log.getDefault().log("Warning: From node on IR " + this.getLabel() + " is not a Method", 1);
        }
        if (this.getTo() != null && !this.getTo().isVirtual() && !(this.getTo() instanceof Resource)) {
            Log.getDefault().log("Warning: To node on IR " + this.getLabel() + " is not a Resource", 1);
        }
        sb.append("(spec_produces\n");
        sb.append(super.toTTaems(v));
        if (this.getCost() != null) {
            sb.append("   (produces " + this.getProduces().output() + ")\n");
        }
        sb.append(")\n");
        return sb.toString();
    }
}

