/*
 * Decompiled with CFR 0.152.
 */
package taems;

import java.io.Serializable;
import taems.Node;
import utilities.Distribution;

public class Outcome
implements Serializable,
Cloneable {
    protected String label;
    protected Distribution quality;
    protected Distribution duration;
    protected Distribution cost;
    protected float density = 1.0f;

    public Outcome(String l, Distribution q, Distribution d, Distribution c, float dens) {
        this.label = l;
        this.quality = q;
        this.duration = d;
        this.cost = c;
        this.density = dens;
    }

    public Outcome(String l) {
        this(l, null, null, null, 1.0f);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String l) {
        this.label = l;
    }

    public Distribution getDuration() {
        return this.duration;
    }

    public void setDuration(Distribution d) {
        this.duration = d;
    }

    public Distribution getQuality() {
        return this.quality;
    }

    public void setQuality(Distribution q) {
        this.quality = q;
    }

    public Distribution getCost() {
        return this.cost;
    }

    public void setCost(Distribution c) {
        this.cost = c;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float d) {
        this.density = d;
    }

    public String toTTaems(float v) {
        StringBuffer sb = new StringBuffer("      (" + this.label + "\n");
        sb.append("         (density " + this.density + ")\n");
        if (this.quality != null) {
            sb.append("         (quality_distribution " + this.quality.output() + ")\n");
        }
        if (this.duration != null) {
            sb.append("         (duration_distribution " + this.duration.output() + ")\n");
        }
        if (this.cost != null) {
            sb.append("         (cost_distribution " + this.cost.output() + ")\n");
        }
        sb.append("      )\n");
        return sb.toString();
    }

    public String toString() {
        return this.toTTaems(1.1f);
    }

    public boolean matches(Outcome o) {
        if (o != null) {
            if (!Node.matches(o.getLabel(), this.getLabel())) {
                return false;
            }
            if (!Node.matches(o.getDuration(), this.getDuration())) {
                return false;
            }
            if (!Node.matches(o.getQuality(), this.getQuality())) {
                return false;
            }
            if (!Node.matches(o.getCost(), this.getCost())) {
                return false;
            }
            if (!Node.matches(o.getDensity(), this.getDensity())) {
                return false;
            }
        }
        return true;
    }

    public Object clone() {
        Outcome cloned = null;
        try {
            cloned = (Outcome)super.clone();
        }
        catch (Exception e) {
            System.out.println("Clone Error: " + e);
        }
        if (this.getLabel() != null) {
            cloned.setLabel(new String(this.getLabel()));
        } else {
            cloned.setLabel(null);
        }
        if (this.duration != null) {
            cloned.setDuration((Distribution)this.duration.clone());
        } else {
            cloned.setDuration(null);
        }
        if (this.quality != null) {
            cloned.setQuality((Distribution)this.quality.clone());
        } else {
            cloned.setQuality(null);
        }
        if (this.cost != null) {
            cloned.setCost((Distribution)this.cost.clone());
        } else {
            cloned.setCost(null);
        }
        if (this.density != Float.NEGATIVE_INFINITY) {
            cloned.setDensity(this.density);
        } else {
            cloned.setDensity(this.density);
        }
        return cloned;
    }
}

